import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';
import 'config.dart';

class StudentEditPage extends StatefulWidget {
  @override
  _StudentEditPageState createState() => _StudentEditPageState();
}

class _StudentEditPageState extends State<StudentEditPage> {
  final TextEditingController _firstNameController = TextEditingController();
  final TextEditingController _lastNameController = TextEditingController();
  final TextEditingController _studentNumberController = TextEditingController();

  Future<void> _addStudentToSheet() async {
    final uri = Uri.parse(AppConfig.urlAPI);
    final response = await http.post(uri,
        headers: {
          "Content-Type": "application/json",
        },
        body: json.encode({
          "values": [
            [
              _firstNameController.text,
              _lastNameController.text,
              _studentNumberController.text,
              "", // NFC Code, vide pour le moment
              "oui"
            ]
          ]
        }));

    print('Statut de la réponse: ${response.statusCode}');
    if (response.statusCode == 200) {
      print('Réponse du serveur: ${response.body}');
      Navigator.pop(context);
    } else if (response.statusCode == 302) {
      var newUri = response.headers['location'];
      if (newUri != null) {
        print('Réponse du serveur: ${response.body}');
        Navigator.pop(context);
      }
    } else {
      print('Erreur lors de l\'ajout de l\'étudiant: ${response.body}');
      ScaffoldMessenger.of(context).showSnackBar(SnackBar(
        content: Text("Erreur lors de l'ajout de l'étudiant"),
      ));
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text("Ajouter un étudiant")),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          children: [
            TextField(
              controller: _firstNameController,
              decoration: InputDecoration(labelText: "Prénom de l'étudiant"),
            ),
            TextField(
              controller: _lastNameController,
              decoration: InputDecoration(labelText: "Nom de l'étudiant"),
            ),
            TextField(
              controller: _studentNumberController,
              decoration: InputDecoration(labelText: "Numéro de l'étudiant"),
            ),
            ElevatedButton(
              onPressed: _addStudentToSheet,
              child: Text("Ajouter à la Google Sheet"),
            ),
          ],
        ),
      ),
    );
  }
}
