import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'package:open_file/open_file.dart';
import 'package:pdf/widgets.dart' as pw;
import 'data_page.dart';
import 'student_edit_page.dart';
import 'config.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter NFC App',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: const HomePage(),
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  final TextEditingController _googleSheetsLinkController =
  TextEditingController();

  bool _isValidGoogleSheetsLink(String link) {
    RegExp regex = RegExp(
        r'https:\/\/docs\.google\.com\/spreadsheets\/d\/[a-zA-Z0-9_-]+\/(edit|pubhtml).*');
    return regex.hasMatch(link);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Flutter NFC App'),
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            const Text(
              'Bienvenue dans votre application NFC !',
              style: TextStyle(fontSize: 20.0, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 20.0),
            TextField(
              controller: _googleSheetsLinkController,
              decoration: InputDecoration(
                labelText: 'Entrez le lien Google Sheets',
                border: OutlineInputBorder(),
              ),
            ),
            const SizedBox(height: 20.0),
            ElevatedButton(
              onPressed: () {
                String googleSheetsLink = _googleSheetsLinkController.text;
                if (_isValidGoogleSheetsLink(googleSheetsLink)) {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) =>
                          DataPage(googleSheetsLink: googleSheetsLink),
                    ),
                  );
                } else {
                  showDialog(
                    context: context,
                    builder: (context) {
                      return AlertDialog(
                        title: const Text('Lien Google Sheets invalide'),
                        content: const Text(
                            'Veuillez saisir un lien Google Sheets valide.'),
                        actions: <Widget>[
                          TextButton(
                            onPressed: () {
                              Navigator.pop(context);
                            },
                            child: const Text('OK'),
                          ),
                        ],
                      );
                    },
                  );
                }
              },
              child: const Text('Continuer'),
            ),
            const SizedBox(height: 20.0), // Espace supplémentaire
            // Bouton pour naviguer vers la page d'ajout d'étudiant
            ElevatedButton(
              onPressed: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (context) => StudentEditPage()),
                );
              },
              child: const Text('Ajouter un étudiant'),
            ),
          ],
        ),
      ),
    );
  }
}


