const express = require('express');
const app = express();
const port = 3000;

// Constantes
const rayonSeau = 15; // Le rayon du seau en cm
const hauteurInitialeEau = 50; // la hauteur initiale de l'eau en cm
const distanceSupplementaire = 5; // la distance supplémentaire en cm entre le capteur et le bord supérieur du seau
let volumeEauInitial = Math.PI * rayonSeau**2 * hauteurInitialeEau; // Calcul du volume d'eau initial en cm^3 (mL)

app.use(express.json());

const path = require('path');

app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, 'index.html'));
});

app.post('/distance', (req, res) => {
    const { distance } = req.body;
    console.log(`Distance reçue: ${distance} cm`);
    res.status(200).json({ message: 'Distance reçue avec succès' });
});

// Route pour définir/mettre à jour le volume d'eau initial
app.post('/definir-volume-initial', (req, res) => {
    const { hauteurEau } = req.body; // Hauteur d'eau fournie par l'utilisateur
    volumeEauInitial = Math.PI * rayonSeau**2 * hauteurEau; // Mise à jour du volume d'eau initial
    res.json({ message: 'Volume d\'eau initial mis à jour', volumeEauInitial });
});


// Route pour calculer le volume d'eau et la consommation
app.post('/calculer-volume', (req, res) => {
    const { distanceCapteur } = req.body;

    const distanceReelle = distanceCapteur - distanceSupplementaire;
    const hauteurEau = hauteurInitialeEau - distanceReelle;
    const volumeEau = Math.PI * rayonSeau**2 * hauteurEau;
    const consommationEau = volumeEauInitial - volumeEau;

    res.json({
        hauteurEau,
        volumeEau,
        consommationEau
    });
});


app.listen(port, () => {
    console.log(`Server listening at http://localhost:${port}`);
});
