import serial
import requests
import time
import os
import asyncio
import websockets

from dotenv import load_dotenv

load_dotenv()


api_url = os.getenv('API_URL')
calculer_consommation =  api_url + '/calculer-volume-consumption'
methode_notification_url = api_url + '/methode-notification'

temps_recuperation_method_notification = os.getenv('TEMPS_RECUPERATION_METHOD_NOTIFICATION') # en secondes
temps_recuperation_distance = os.getenv('TEMPS_RECUPERATION_DISTANCE') # en secondes

arduino_port = '/dev/ttyACM0'
ser = serial.Serial(arduino_port, 9600, timeout=1)

async def fetch_methode_notification():
    try:
        notification_reponse = await requests.get(methode_notification_url)
        notification_reponse.raise_for_status()
        notification_methode = notification_reponse.json().get('methodeNotification', 'sound')
    except requests.exceptions.RequestException as e:
        print(f"Erreur lors de la récupération de la méthode de notification : {e}")
        notification_methode = 'sound'

    return notification_methode

async def process_distance(distance):
    payload = {'distance': distance}
    try:
        reponse = await requests.post(calculer_consommation, json=payload)
        reponse.raise_for_status()
        data = reponse.json()
        print(f"API Response: {data}")
    except requests.exceptions.RequestException as e:
        print(f"Erreur lors de l'appel API : {e}")

async def process_notification(message):
    print(f"Notification reçue : {message}")

    parts = message.split(':')
    if len(parts) == 2 and parts[0] == 'MethodNotification':
        notification_methode = parts[1]
        print(f"Nouvelle méthode de notification reçue: {notification_methode}")
        ser.write(notification_methode.encode())

async def main():
    async with websockets.connect('ws://localhost:3000') as websocket:
        try:
            while True:
                # Attendre un message du serveur WebSocket
                message = await websocket.recv()

                # Traitement du message reçu
                await process_notification(message)

                # Récupérer la méthode de notification actuelle toutes les 20 minutes
                """
                if time.time() % 1200 == 0:
                    notification_method = await fetch_methode_notification()

                    # Envoyer la méthode de notification au serveur WebSocket
                    await websocket.send(f'MethodNotification:{notification_method}')
                """

                # Récupérer la distance toutes les 5 minutes
                if time.time() % 300 == 0:
                    line = ser.readline().decode('utf-8').rstrip()

                    if 'Distance' in line:
                        distance = float(line.split(':')[-1].strip().split(' ')[0])
                        print(f"Distance : {distance} cm")

                        # Traitement de la distance
                        await process_distance(distance)

                await time.sleep(1)

        except KeyboardInterrupt:
            ser.close()
            print("Arrêt du programme.")

if __name__ == "__main__":
    asyncio.get_event_loop().run_until_complete(main())
