#include "Ultrasonic.h"
Ultrasonic ultrasonic(pinTrig, pinEcho);

int pinTrig = 9;
int pinEcho = 8;
int ledPinGreen = 11;
int ledPinRed = 12;
int limitGreen = 10;
int limitRed = 10;
int pinBuzzer = 6;



long temps;
float distance;

void setup() {
    pinMode(pinTrig, OUTPUT);
    pinMode(pinEcho, INPUT);
    pinMode(pinBuzzer, OUTPUT);
    pinMode(ledPinGreen, OUTPUT);
    pinMode(ledPinRed, OUTPUT);

    digitalWrite(pinTrig, LOW);

    Serial.begin(9600);
}

void loop() {
    digitalWrite(pinTrig, HIGH);
    delayMicroseconds(10);
    digitalWrite(pinTrig, LOW);

    temps = pulseIn(pinEcho, HIGH);

    if (temps > 25000){
        Serial.println("Out of range");
        /*digitalWrite(ledPinGreen, HIGH);
        digitalWrite(ledPinRed, HIGH);
        tone(pinBuzzer, 1000); */
    }
    else{
        temps = temps / 2;
        distance = temps * 340 / 10000.0;
        //Serial.print("Temps : ");
        //Serial.print(temps);
        //Serial.println(" µs");

        /*Serial.print("Distance : ");
        Serial.print(distance);
        Serial.println(" cm");*/

        int dist = ultrasonic.distanceRead(CM);
        Serial.print("Ultrasonic Distance : ");
        Serial.print(distance);
        Serial.println(" cm");

        if (distance < limitGreen) {
            digitalWrite(ledPinGreen, LOW);
            digitalWrite(ledPinRed, HIGH);
            tone(pinBuzzer, 1000); 
        }
        else if (distance > limitRed) {
            digitalWrite(ledPinGreen, HIGH);
            digitalWrite(ledPinRed, LOW);
            noTone(pinBuzzer); 
        }
        else {
            noTone(pinBuzzer);
        }
    }
    delay(500);
}

