const chai = require('chai');
const chaiHttp = require('chai-http');
const expect = chai.expect;

const app = require('../routes/index.js');
const mongoose = require('mongoose');
const Consommation = require('../models/consommation.js');

chai.use(chaiHttp);

describe('API Tests', () => {
    describe('GET /consommations', () => {
        it('should return all consommations', async () => {
            const res = await chai.request(app).get('/consommations');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('Get /', () => {
        it('should return 200', async () => {
            const res = await chai.request(app).get('/');
            expect(res).to.have.status(200);
        });
    });
    describe('GET /consommations/par-jour', () => {
        it('should return consommations by day', async () => {
            const res = await chai.request(app).get('/consommations/par-jour');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('GET /consommations/par-semaine', () => {
        it('should return consommations by week', async () => {
            const res = await chai.request(app).get('/consommations/par-semaine');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('GET /consommations/par-mois', () => {
        it('should return consommations by month', async () => {
            const res = await chai.request(app).get('/consommations/par-mois');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('GET /consommations/par-annee', () => {
        it('should return consommations by year', async () => {
            const res = await chai.request(app).get('/consommations/par-annee');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('GET /consommations/:start/:end', () => {
        it('should return consommations by start and end', async () => {
            const res = await chai.request(app).get('/consommations/2021-01-01/2021-12-31');
            expect(res).to.have.status(200);
            expect(res.body).to.be.an('array');
        });
    });
    describe('GET /parametres-seau', () => {
        it('should return seau parameters', async () => {
            const res = await chai.request(app).get('/parametres-seau');
            expect(res).to.have.status(200);
        });
    });
    describe('GET /methode-notification', () => {
        it('should return notification method', async () => {
            const res = await chai.request(app).get('/methode-notification');
            expect(res).to.have.status(200);
        });
    });
});
