# Abreuvoire

## Description du projet

### Objectif :
Le système vise à surveiller et à enregistrer les niveaux de consommation d'eau d'un abreuvoir, fournissant ainsi aux utilisateurs des informations détaillées sur la quantité d'eau consommée sur différentes périodes de temps.

## Schéma

![schema](IOT.drawio.png)

## Arduino

- Mettez le code qui est dans le dossier `arduino/abreuvoire.c` dans votre Arduino .

- Ajoutez un fichier `.env` dans le dossier `readPortSerie` avec le temps de récupération des notifications et la distance de récupération comme l'exemple suivant :

```Shell
TEMPS_RECUPERATION_METHOD_NOTIFICATION=1200
TEMPS_RECUPERATION_DISTANCE=300
```

## Application web

- Ajoutez un fichier `.env` dans le dossier `app` avec les dimensions de votre seau comme l'exemple suivant :

```Shell
RAYON_SEAU=15
HAUTEUR_INITIALE_EAU=50
DISTANCE_SUPPLEMENTAIRE=5
```

## Lancement de l'application

- Mettez-vous à la racine du projet.

- Build et lancement des containers :
```Shell
docker compose up --build
```

- Destruction des containers :
```Shell
docker compose down
```

