const chai = require('chai');
const chaiHttp = require('chai-http');
const expect = chai.expect;

const app = require('../routes/index.js');
const mongoose = require('mongoose');
const Consommation = require('../models/consommation.js');

chai.use(chaiHttp);

describe('API Tests', () => {
    describe('Get /', () => {
        it('should return 200', async () => {
            const res = await chai.request(app).get('/');
            expect(res).to.have.status(200);
            expect(res).to.be.html;
        });
    });
    describe('Test de la route GET /information-generale', () => {
        it('devrait renvoyer le code 200 et rendre la vue dashboard', (done) => {
            chai.request(app)
                .get('/information-generale')
                .end((err, res) => {
                    expect(res).to.have.status(200);
                    expect(res).to.be.html;
                    done();
                });
        });
    });
    describe('Test de la route GET /graphique-consommations', () => {
        it('devrait renvoyer le code 200 et rendre la vue chart.pug', async () => {
            const res = await chai.request(app).get('/graphique-consommations');
            expect(res).to.have.status(200);
            expect(res).to.be.html;
        });
    });

    describe('Test de la route GET /liste-consommations', () => {
        it('devrait renvoyer le code 200 et rendre la vue lastConsumptions.pug', async () => {
            const res = await chai.request(app).get('/liste-consommations');
            expect(res).to.have.status(200);
            expect(res).to.be.html;
        });
    });
    describe('Test de la route GET /consommations-par-periode', () => {
        it('devrait renvoyer le code 200 et rendre la vue consumptionsByPeriod.pug', async () => {
            const res = await chai.request(app).get('/consommations-par-periode');
            expect(res).to.have.status(200);
            expect(res).to.be.html;
        });
    });
    describe('GET /consommations', () => {
        it('should return all consommations', async () => {
            const res = await chai.request(app).get('/consommations');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');
        });
    });
    describe('Test des routes GET /consommations/:startDate/:endDate', () => {
        it('devrait renvoyer le code 200 et un tableau de consommations dans la plage de dates spécifiée', async () => {
            // Supposons que startDate et endDate soient des dates valides au format 'YYYY-MM-DD'
            const startDate = '2023-01-01';
            const endDate = '2023-02-01';

            const res = await chai.request(app).get(`/consommations/${startDate}/${endDate}`);
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');
        });

        it('devrait renvoyer le code 500 en cas d\'erreur', async () => {
            // Supposons que startDate et endDate soient des dates invalides au format 'YYYY-MM-DD'
            const startDate = 'invalid-date';
            const endDate = 'invalid-date';

            const res = await chai.request(app).get(`/consommations/${startDate}/${endDate}`);
            expect(res).to.have.status(500);
            expect(res).to.be.json;
            expect(res.body).to.have.property('message');
        });
    });
    describe('Test de la route GET /dernieres-consommations', () => {
        it('devrait renvoyer le code 200 et les 10 dernières consommations', async () => {
            const res = await chai.request(app).get('/dernieres-consommations');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array').with.lengthOf(10); // Assurez-vous d'ajuster la longueur en fonction de votre logique métier
        });
    });
    describe('GET /consommations/par-jour', () => {
        it('should return consommations by day', async () => {
            const res = await chai.request(app).get('/consommations/par-jour');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');
            // Assurez-vous que chaque élément de la réponse a les propriétés attendues
            res.body.forEach(item => {
                expect(item).to.have.property('_id');
                expect(item).to.have.property('totalConsommation');
            });
        });
    });
    describe('GET /consommations/par-semaine', () => {
        it('should return consommations by week', async () => {
            const res = await chai.request(app).get('/consommations/par-semaine');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');

            // Assurez-vous que chaque élément de la réponse a les propriétés attendues
            res.body.forEach(item => {
                expect(item).to.have.property('_id');
                expect(item).to.have.property('totalConsommation');
            });
        });
    });
    describe('GET /consommations/par-mois', () => {
        it('should return consommations by month', async () => {
            const res = await chai.request(app).get('/consommations/par-mois');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');

            // Assurez-vous que chaque élément de la réponse a les propriétés attendues
            res.body.forEach(item => {
                expect(item).to.have.property('_id');
                expect(item).to.have.property('totalConsommation');
            });
        });
    });
    describe('GET /consommations/par-annee', () => {
        it('should return consommations by year', async () => {
            const res = await chai.request(app).get('/consommations/par-annee');
            expect(res).to.have.status(200);
            expect(res).to.be.json;
            expect(res.body).to.be.an('array');

            // Assurez-vous que chaque élément de la réponse a les propriétés attendues
            res.body.forEach(item => {
                expect(item).to.have.property('_id');
                expect(item).to.have.property('totalConsommation');
            });
        });
    });
    describe('GET /parametres-seau', () => {
        it('should return seau parameters', async () => {
            const res = await chai.request(app).get('/parametres-seau');
            expect(res).to.have.status(200);
            expect(res).to.be.json;

            // Assurez-vous que la réponse a les propriétés attendues
            expect(res.body).to.have.property('rayonSeau');
            expect(res.body).to.have.property('hauteurInitialeEau');
            expect(res.body).to.have.property('distanceSupplementaire');
            expect(res.body).to.have.property('volumeEauInitial');
        });
    });
    describe('GET /methode-notification', () => {
        it('should return notification method', async () => {
            const res = await chai.request(app).get('/methode-notification');
            expect(res).to.have.status(200);

            expect(res).to.be.json;

            // Assurez-vous que la réponse a la propriété attendue
            expect(res.body).to.have.property('methodeNotification');
        });
    });
});
