# Abreuvoire

## Description du projet

### Objectif :
Le système vise à surveiller et à enregistrer les niveaux de consommation d'eau d'un abreuvoir, fournissant ainsi aux utilisateurs des informations détaillées sur la quantité d'eau consommée sur différentes périodes de temps.

## Schéma

![schema](IOT.drawio.png)

## Application web

- Ajoutez un fichier `.env` dans le dossier `app` avec les dimensions de votre seau comme l'exemple suivant :

```Shell
RAYON_SEAU=15
HAUTEUR_INITIALE_EAU=50
DISTANCE_SUPPLEMENTAIRE=5
```

## Lancement de l'application

- Mettez-vous à la racine du projet.

- Build et lancement des containers :
```Shell
docker compose up --build
```

- Destruction des containers :
```Shell
docker compose down
```

## Arduino

- Mettez le code qui est dans le dossier `arduino/abreuvoire.c` dans votre Arduino .

- Mettez-vous sur le dossier 'readPortSerie' .

- Ajoutez un fichier `.env` dans le dossier `readPortSerie` avec les infos de votres port serie et le temps de récupération de la distance comme l'exemple suivant :

```Shell
SERVER_WS=ws://localhost:3000

ARDUINO_PORT=/dev/ttyACM0
BAUDRATE=9600
TIMEOUT=1

TEMPS_RECUPERATION_DISTANCE=60
```

- Lancement du client :
```Shell
sudo docker-compose up --build
```

- Destruction des containers :
```Shell
sudo docker-compose down
```
