
export const version = () => "1.5.0";

export function* createSensorJSON(json){
	if(! Array.isArray(json)) json = [json];

	for(let sensor of json){

		let ret;

		switch(sensor.type){
			case SensorType.TEMPERATURE : {
					ret = new Temperature(sensor.id, sensor.name, sensor.data.values, sensor.data.labels);
				break;
			}
			case SensorType.DOOR : {
					ret = new Door(sensor.id, sensor.name, sensor.data.value);
				break;
			}
			case SensorType.FAN : {
					ret = new Fan(sensor.id, sensor.name, sensor.data.values, sensor.data.labels);
				break;
			}
			default: {

				let id, name, values, labels;

				if(sensor.id !== undefined) id = sensor.id;
				if(sensor.name !== undefined) name = sensor.name;
				if(sensor.data !== undefined){
					if(sensor.data.values !== undefined) values = sensor.data.values;
					if(sensor.data.value !== undefined) values = sensor.data.value;
					if(sensor.data.labels !== undefined) labels = sensor.data.labels;
				}

				ret = new Sensor(id, name, values, labels);
			}
		}

		yield ret;
	}
}



const SensorType = {
	TEMPERATURE : 'TEMPERATURE',
	HUMIDITY : 'HUMIDITY',
	LIGHT : 'LIGHT',
	SENSOR : 'SENSOR',
	SWITCH : 'SWITCH',
	FAN : "FAN_SPEED",
	DOOR : 'DOOR'
};

export class Sensor {
	constructor(id, name, values, labels) {

		if(Number.isInteger(id)) this._id = id;
		if(typeof name === 'string')this._name = name;

		this._type = "SENSOR";

		this.initValues(values, labels);
	}

	initValues(values, labels){

		if((! Array.isArray(values)) && (values !== undefined)){ values = [values]; }
		if((! Array.isArray(labels)) && (labels !== undefined)){ labels = [labels]; }

		if((values !== undefined && labels !== undefined) && (values.length === labels.length)){
			this._values = values;
			this._labels = labels;
		}else{
			if( (values !== undefined && values.length === 1) && (labels === undefined || labels.length === 0)){
				this._values = values[0];
				console.info("Only one value, add function disable");
			}else{
				this._values = [];
				this._labels = [];
				console.info("No values initialize");
			}
		}
	}

	get id(){
		return this._id;
	}

	get name(){
		return this._name;
	}

	/* Values */

	get values(){
		return {values : this._values, labels : this._labels};
	}

	get type(){
		return this._type;
	}

	get lastData(){
		return {value : this._values[this._labels.length - 1], label : this._labels[this._labels.length - 1]};
	}

	get length(){
		return this._values.length;
	}

	shift(){
		this._values.shift();
		this._labels.shift();
	}

	value(id){
		return {value : this._values[id], label : this._labels[id]};
	}

	addValue(value, label){
		this._values.push(value);
		return this._labels.push(label);
	}

	* generator(){
		for(var i = 0; i < this._values.length; i++){
			yield {value : this._values[i], label : this._labels[i]};
		}
	}

	/* */

	toString() {
		return (`(${this._id}, ${this._name} ,{${this._values}} , {${this._labels}})`);
	}
}

export class Temperature extends Sensor {

	constructor(id, name, values, labels){

		super(id, name, values, labels);

		this._type = "TEMPERATURE";

		this.validatorTypeValues();
	}

	get average(){
		let sum = this._values.reduce(function(a, b) { return parseFloat(a) + parseFloat(b); });
		let avg = sum / this._values.length;

		return avg;
	}

	validatorTypeValues(){

		//Désactiver car Float
		/*if(this._values.filter(function(i){
			return Number.isInteger(i);
		}).length < this._values.length) throw ("Only numerical value is accepted in values");

		var regex = /^(19|20)\d{2}-(0[1-9]|1[0-2])-(0[1-9]|[1-2]\d|3[01])T([01]\d|2[0-3]):([0-5]\d):([0-5]\d).\d{3}Z$/;
		if(this._labels.filter(function(s){
			return regex.test(s);
		}).length < this._values.length) throw ("Only date value is accepted in labels");*/

	}

	addValue(value, label){
		/*if(! Number.isInteger(value)) throw ("Only numerical value is accepted in values"); //Désactiver car Float
		var regex = /^(19|20)\d{2}-(0[1-9]|1[0-2])-(0[1-9]|[1-2]\d|3[01])T([01]\d|2[0-3]):([0-5]\d):([0-5]\d).\d{3}Z$/;
		if(! regex.test(label)) throw ("Only date value is accepted in labels");*/
		return super.addValue(value, label);
	}
}

export class Door extends Sensor {
	constructor(id, name, value, label){
		super(id, name, value, label);

		this._type = "DOOR";
	}

	get value(){
		return super.values.values;
	}

	switchPosition(){
		if(this._values === 0) this._values = 1;
		else this._values = 0;
		return this._values;
	}

	toString() {
		let tmp = "";
		if(this._values === 0) tmp = 'close'; else tmp = 'open';

		return ('The door is ' + tmp + ' ( ' + this._values + ' )');
	}
}

export class Fan extends Sensor {

	constructor(id, name, values, labels){

		super(id, name, values, labels);

		this._type = "FAN_SPEED";

		this.validatorTypeValues();
	}

	validatorTypeValues(){

		/*if(this._values.filter(function(i){
			return Number.isInteger(i);
		}).length < this._values.length) throw ("Only numerical value is accepted in values");

		var regex = /^(19|20)\d{2}-(0[1-9]|1[0-2])-(0[1-9]|[1-2]\d|3[01])T([01]\d|2[0-3]):([0-5]\d):([0-5]\d).\d{3}Z$/;
		if(this._labels.filter(function(s){
			return regex.test(s);
		}).length < this._values.length) throw ("Only date value is accepted in labels");*/

	}
}
