import * as types from './ActionTypes';
import mqtt from 'mqtt';
import * as captors from '../service/sensor';
var listCapteurs = [];
var url = "ws://localhost:1234";
var listeRoute = [];
function getIndex(name){
  var index = -1;

  for(var i=0; i<listCapteurs.length; i++){
    if(listCapteurs[i].name === name){
      index = i;
      break;
    }
  }

  return index;
}

function valideURL(s) {
  var regexp = /(ws):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
  return regexp.test(s);
}


export function connectionAction() {
  console.log('blue');
  return function(dispatch, getState) {
    dispatch({ type: "CONNECTION_REQUESTED" });
    console.log('green');
    return new Promise(function(resolve, reject) {
      var client = mqtt.connect("mqtt://localhost:1234");
      client.on("connect", function() {
        client.subscribe("#");
        resolve();
      });
      client.on("message", function(topic, message) {

          //listCapteurs.push(sensor);


      //  message = JSON.parse(message.toString());
      ///  const nomCapteur = topic.match(/value\/(.*)/)[1]
      //  const typeCapteur = message.type
       let tmp = [topic, message].join("|").split('|')[1];
          let tmp2 = JSON.parse(tmp);
          let id;
          let dt = new Date();
          let date = dt.toISOString();
        let json = {"id":id,"name":name,"type":tmp2.type,"data":{"values": tmp2.value, "labels": date}};
          let gen = captors.createSensorJSON(json);
          let sensor = gen.next().value;
          let listCapteurs =[];
          message = JSON.parse(message.toString());
                  const nomCapteur = topic.match(/value\/(.*)/)[1];
                  const typeCapteur = message.type;
                  let estNouveauCapteur =(typeof listCapteurs[nomCapteur] === 'undefined');

                  /**if (estNouveauCapteur){
                  listCapteurs.push(nomCapteur);
                }*/
      //  const estNouveauCapteur = typeof getState().sensor.name'] === 'undefined';

        if (estNouveauCapteur) {
            dispatch({
                type: types.ADD_CAPTEUR,
              params:{
                name: nomCapteur,
                type: typeCapteur,
                value: message.value
              }
            });
        } else {
            dispatch({
                type: types.CHANGE_CAPTEUR,
              params:{
                name: nomCapteur,
                value: message.value
              }
            });
        }
      });
    })
      .then(() => dispatch({ type: "CONNECTION_ESTABLISHED" }))
      .catch(() => dispatch({ type: "CONNECTION_REJECTED" }));
  };
}
