'use strict';

// Utility class for ledger state
const State = require('../ledger-api/state.js');

// Enumerate the car state values
const carState = {
    FOR_SALE: 1,
    SOLD: 2
};


/**
 * Car class that will be used by apps and smart contract to define a car
 */
class Car extends State{
    constructor(obj){
        super(Car.getClass(), [obj.seller, obj.carNumber]);
        Object.assign(this, obj);
    }

    /**
     * Getters & setters
     */
    getSeller(){
        return this.seller;
    }

    setSeller(newSeller){
        this.seller = newSeller;
    }

    getOwner(){
        return this.owner;
    }

    setOwner(newOwner){
        this.owner = newOwner;
    }

    getPrice(){
        return this.price;
    }

    /**
     * Handling the car state
     */
    setForSale(){
        this.currentState = carState.FOR_SALE;
    }

    setSold(){
        this.currentState = carState.SOLD;
    }

    isForSale(){
        return this.currentState === carState.FOR_SALE;
    }

    isSold(){
        return this.currentState === carState.SOLD;
    }

    static fromBuffer(buffer){
        return Car.deserialize(buffer);
    }

    toBuffer(){
        return Buffer.from(JSON.stringify(this));
    }

    static deserialize(data){
        return State.deserializeClass(data, Car);
    }

    /**
     * Factory method to create a car to sale
     */
    static createInstance(seller, carNumber, carBrand, carModel, price){
        return new Car({seller, carNumber, carBrand, carModel, price});
    }

    static getClass() {
        return 'org.carmarket.car';
    }
}

module.exports = Car;
