/* Official ECDSA test vectors.
 *
 * Source:
 * http://csrc.nist.gov/groups/STM/cavp/index.html
 * http://csrc.nist.gov/groups/STM/cavp/documents/dss/186-3ecdsatestvectors.zip
 */

sjcl.test.vector.ecdsa = {
  "p192sha1" : [
    {
      msg: "ebf748d748ebbca7d29fb473698a6e6b4fb10c865d4af024cc39ae3df3464ba4f1d6d40f32bf9618a91bb5986fa1a2af048a0e14dc51e5267eb05e127d689d0ac6f1a7f156ce066316b971cc7a11d0fd7a2093e27cf2d08727a4e6748cc32fd59c7810c5b9019df21cdcc0bca432c0a3eed0785387508877114359cee4a071cf",
      d: "e14f37b3d1374ff8b03f41b9b3fdd2f0ebccf275d660d7f3",
      Qx: "07008ea40b08dbe76432096e80a2494c94982d2d5bcf98e6",
      Qy: "76fab681d00b414ea636ba215de26d98c41bd7f2e4d65477",
      k: "cb0abc7043a10783684556fb12c4154d57bc31a289685f25",
      R: "6994d962bdd0d793ffddf855ec5bf2f91a9698b46258a63e",
      S: "02ba6465a234903744ab02bc8521405b73cf5fc00e1a9f41"
    },
    {
      msg: "0dcb3e96d77ee64e9d0a350d31563d525755fc675f0c833504e83fc69c030181b42fe80c378e86274a93922c570d54a7a358c05755ec3ae91928e02236e81b43e596e4ccbf6a9104889c388072bec4e1faeae11fe4eb24fa4f9573560dcf2e3abc703c526d46d502c7a7222583431cc8178354ae7dbb84e3479917707bce0968",
      d: "7a0235bea3d70445f14d56f9b7fb80ec8ff4eb2f76865244",
      Qx: "0ea3c1fa1f124f26530cbfddeb831eecc67df31e08889d1d",
      Qy: "7215a0cce0501b47903bd8fe1179c2dfe07bd076f89f5225",
      k: "3c646b0f03f5575e5fd463d4319817ce8bd3022eaf551cef",
      R: "a3ba51c39c43991d87dff0f34d0bec7c883299e04f60f95e",
      S: "8a7f9c59c6d65ad390e4c19636ba92b53be5d0f848b4e1f7"
    },
    {
      msg: "9408392847e3a387307fbc6789669974fbdaa49b5f2bd5510895105a11dff9c1caab7e327cec80c281e3d9ff13b9e37bbbd2342da7543733bff9aabbfeacc75a40c75a2c5d2b159290428761b64689e5d51224da41da22482c95965422946a644a8becec98f55f1403f23dc794ee889bf02eb7d833f4d465713201e8460a66ce",
      d: "e16f2aaee2aec553ecd538367a03c3d72bfcc5c7ab4d4ca0",
      Qx: "44e1499e104bf04262aebd26ebad3b3a4980af03c5224b0e",
      Qy: "5c2214b22bb07187e1fbe2728ac9f667277c6645fc5d3392",
      k: "aed61c2dacf8aff0e85c0c5f8f4daa19bdcea7f5ee33027c",
      R: "7fd327a0e6ef4c27b09483818fd784f569f97e6c979a4f31",
      S: "95a1db7b13790e2205dfdb81c2da97bb9bc3d7dd3dd0d91a"
    },
    {
      msg: "76f5eea4ad9d8028542b712a26f37151fd2bbb44f28520d19a3ba4ab919877f24095f9a77a0c7e66388394605241690acc151c283e53de22cfabe7a983a532a4870be28d77c215e244350aa4ad4ccc73c2e098d1f0fc4ceda2d5a23c265cc26312eb6532b5694f1fbd2af32121f41e3cba07d27389bf54a76803dfa6795e286e",
      d: "2a004cbd89d7a6cbe2c39e362fb537845b19cd6c50e08527",
      Qx: "e6135a418ede8adbb685b08294cc274ce08a3dcdacac7fd4",
      Qy: "c0c4fffed855aec46fd95ad4c4a15a17659d2cacd2a8ba03",
      k: "7bdd329bb76fe8045bc86851b1dcff3c96363c8b07bbfca8",
      R: "de556e8d15a5e1e7d318c7051341ac0dc6698950b8c5b859",
      S: "8f36c906d66cb47388b09343129dc29176469db84ddd8d95"
    },
    {
      msg: "5d26f9e60babc8ea6338c51610c06450d27378487afd041ab63c01f9c659618f0d5fc3b5c3253b17b77fec62f4dbe8cd2fd7eb67dfdaaa2cc217c603837c9edb717967ee5ec43b32da94d5aaea4508837cb90d7916844aa7ca93cf0a12feaf0378f7bb773730410bfc42f8b52bdab39076e584b24f9891c53fed8a990a356a50",
      d: "6019413d76958e73e6ba530192f4851097b5ce075e1db438",
      Qx: "20c1007a371c147edfc59207611fb6d5542b0136d9e14f80",
      Qy: "1608c763e6b93361ee0462e308e956cf27cea603fd8ebc11",
      k: "372cb07b0e19db159ed5594b75c21d9f1b9647a2f475eb2f",
      R: "79256149f44a11515d91b470aab4be1f252927f5df0dd84b",
      S: "cc2a17eddfc48db85f449f0fd72cff5e304febeffe670889"
    },
    {
      msg: "dfca280be57fe107874436c23e4c7343dd909e75eaa8418e9429453ac2d000aeed475c8fcec17e424232ba7a2470362d62d52eaf38e9a3a2193f4c61152e3602482448a9d280ac560e57dc26c37262307124c4621b4556b08684c5bc9aaa98a9f57dfe5c2a4d146f09410aa10c55aa48c70850e96c42e368c455d97b5695438a",
      d: "3ebdf68ae0d42d48838f042aecff7ebbdf387ad82bfd3501",
      Qx: "f81eee98efa4361a351e08e9d2abc4083541b2f10f4457f5",
      Qy: "5af7894ba266997943dbee8a4d6e5679713776e7e07a0a2d",
      k: "eab771d6dbec1687a464abaab925d799a84468709af69714",
      R: "0215f1173796e6a61ea99b8d91319a29c3539fc312ad57a8",
      S: "8f22035e01ddb27e1a2ae824461d858b99748d455d3332ab"
    },
    {
      msg: "f13d5607ca5b1e94bb9f2d8e927acca7d9a8a682043b707e68c77cae82fcc6fbf2c17cfd24d0425582d430ecf16f413e5d3d54d1124aa1b8b0d7a144598e736470dcdb0929eaa8911acabf359c72ea588987d6a60394ea98ef2edb182b77f34bd6252b00326bb723e6d1c6bbde85ea4c824e49e716ee7ee4380eae845aba8ae1",
      d: "0ff956a1d81ab1f5c8a2e87340a2429d4b9b3cec54c58944",
      Qx: "15a2805a6195f176c6b32826bd92674f64373565f68e91c8",
      Qy: "25e9e9e7145d331654ef357af1fcf45b8ca350a3853b2b99",
      k: "efc787869f6be3a130f59803e5cd751167de4e851449f2d0",
      R: "b5de4fdf1a0e0d59197720a549eb0ef52a49649f1a70f050",
      S: "683e32589d61512acf24201a0fe8b2f4569d953803f55e35"
    },
    {
      msg: "c45b6b1b2a1ac262012543982d4bb8b6def39e26bf7555aaaf5674c9e72a59c088887f2a9cdf9088cd17b2d739cba152d13464bc69b974d3ea1f56a755aaf4c3d97838aee2953c9c501b2d5d7ee8b702f71b251856d708eb914344746ad487b32aac0d26e67033330745164ef67fd01758aa56e257cf84418a82c50716b8750e",
      d: "f310bd616126225ddf94fb886b62f894585619365aba1317",
      Qx: "fc044c1dc333da8ec98e6598ffaef60e5b230d098102791a",
      Qy: "8e76c0c9a17d292e1aee839766ebcc6ed7b83330d29b8858",
      k: "017448988e6169673975943a6d2de804741d4e8ac16f1545",
      R: "08975a982c05da87ba46ae400ac47b017aa7a82d9a6a8069",
      S: "4ec2b5db62bd287b2ca1ead38e52c36ae03762196848a36a"
    },
    {
      msg: "5b704ad725a178d018165a84947b10f1362adad79198fab15f27f5c973815ddbee53460e158c8cb5506df51b9db21344d4552f311150b507b5bf07c4379016881a4919122ac42bc42bfda78670869f929e3e23f96648493f88744c3972b4e9aab56d12c68bc0a1dd38d447fa09e8acf04df810b889ad0ad789ca2fa43cd9ea05",
      d: "63cd3c5af5d24d2f79f43a4b07a21191c7fc5ff5e1704713",
      Qx: "b6e6015c995f75aa0a1533e8023a367a04143f153632956b",
      Qy: "54331ecd90c8897fc0f831c4443fb08d948fb67ac6ff89d4",
      k: "9f32e05576c3ab9dd2d0cdf30d2c3e4995e27b5102d98c59",
      R: "edb1ff080df6374a3222103d081f4dbbdc50a4028a5595f0",
      S: "ecbb3f470175c9bf1085237661263efaad3a177423865b6b"
    },
    {
      msg: "ac43f3a921e0adef1caacbecaadb9ddeeb53cb88616697121a99c0ab0e42009b16678fad2e1e007942b27ffe9df0e046cd9d1d73d602a5bebb64e25602020e6d94d8ee6a71ad0ef5098f741e0468c191416cc67d1f2995f36b7fd20aa881570e0be3f1f7e42279f3164da8a9fff1d9e4f79b8537a42402548afbd47b87c93e6c",
      d: "e4bce33ca654556851e4d6abf5730c54f8006076261f21dd",
      Qx: "d8b51224389f335fda34681fc4844885ee5138b7ab3d4c0c",
      Qy: "82564d8c3e10f349d9ba928eb5f760a44935e061f8324ab0",
      k: "df31b5371d6f6dadc1f6e752d23dcf748c424b7b27f4ebc8",
      R: "8856b1451f0ff744aba86e9e567be739f0715eaaf5a54402",
      S: "320005598a5d26f18ffd188b34a1680ab7f08aa3834a782a"
    },
    {
      msg: "3497eedbc30525fa62397088127d998570dc839e0cf217cf71751126c8b16ce87b11e5d8f83e11ca4c606c1f90abc5975854a1303a8ce8bafa4bf190f19bc2028f35f81a7cb1e1e460f31007966cb5492f2298a484ed319a017e09e5086315bbdc01b05c3f88f1702b82244623d04765da58a3009e67d7025fe650e4cf915e0e",
      d: "42e9997dde0d1b11ec8fd0ff4a01d0b7123deb08b49aa8df",
      Qx: "c26576a6e2a9ed348245483afc8e0d925f1104ebf8a014d7",
      Qy: "540f780769b6a755d8c7de0c2675c4f4853ab64a172574be",
      k: "f360d85503c5ff5c7a28d5a2ead13c5f6278e5781ef91296",
      R: "9b32f6142c028867f3026fe6c38dad560fd30834dcef7624",
      S: "326c5087d54fcfb7a76820489adcf7c14916577120253940"
    },
    {
      msg: "60e06e0096e10b1b89736ed6c9473a8dee2a69c973830f14497ebf364518843ddfb3bb7acde381805102462e9c2b10151f12a8d5a96e6e6dfaf82deb935c17baa2a9a54c5091d962494b4c515d8934d1f881a9f0c9d687897307cfbd7686afab23f308dddd5ba30a0c9e63656355cfe5ad10394311aa66907f5bd9fde1582849",
      d: "a4b8b72bda49d4b607c73c6765088e0ae8c7445bfd98163b",
      Qx: "edfdc0a324a07bc9e0640ab3b33d8cb4d32bb8d673fe0c9f",
      Qy: "7ec3731330b192fc97c279c4785fa5af0084e3f2e94602aa",
      k: "c525c24f10e83f0f110597af62d0eaf50426b82bf7b74dd9",
      R: "b513b40e9f6d7069b58a1bba95a65f5be65ea9a744629c29",
      S: "caf5a7fdfee32dee5945cbf189b6f3028800ac7fd1cf2342"
    },
    {
      msg: "f7322577fa79a67b7057cd23dfd7dd47bad340beecf0ba9c1c88792c7fead99f4c9cfb4f37ef1a35ad61dcb733bc55cb9d80539c5d904ead03be0520a6f50b75e1032595cd30d9b2c20a733a9f4dc9af72c9886f6add1253d736575e62027e74910750c5bc6621daf5e22140484857daabdd8243b158ad1d4f03582c11f44268",
      d: "47f1a1abb180378e2e0a69b8f1c5fb3f4b20a0604465d61c",
      Qx: "2de12115512085dc58d092e26d1b5c16e4964c811c85aeaf",
      Qy: "3b5ab809bbfe4096d1a1977c84b5ef507ac81bde2123e063",
      k: "c7506b4fe3ed0739244d985d53c4f5a5a4013d4b449d3121",
      R: "9b4a02fde706a17495fced71a15c9e73fb4ab55a38572799",
      S: "7932dfd21e2b82db2ce8a2939c5ce7b870cb838be4a98066"
    },
    {
      msg: "1a359e77397e22c9a6b896c89d74a216ef0ad5e32100e1b0d14960e6541f5077384e07a744b48a15fdb0e32804f012f3a8abbacd8beabc06457dc2eb24623af4293cecd4e201a39d3f3440dca9005113f66e71e7b6ddb74835481f30f09bc0c3c34c47bc61a60f37dce2c97dbfa5611fd292896ba1fad18c56d1b21d51c37743",
      d: "92dbfd711170c0064c3644a55165fc7253905cbc9aab85d4",
      Qx: "b330e90f795624ebc91ff56148c9ac60db7e227e1f70c823",
      Qy: "30829cca9d817123bb2d2acf4c21c01ef126203cf4ad28f5",
      k: "77229ee70de79d2eb5b71ae6844b1e0745c5f679af040f39",
      R: "e780dd8222297b25ff6b3228b7e0c2b46fc5fe4454020894",
      S: "47eb9f182021e8d55ee23c300a1283a136738ad02b8e9fbf"
    },
    {
      msg: "abfd6a51193fe2f4bc69ed658adb102a86b58e39bdb9b88539f1b910461c47997d15ac507f416b8cea3705b96ad4d5ddb2278504a79c8447c8e82a4a19e8b1bc6f8bc2df945daca2c5a6d676be30be198054d8c92a1df624fec6aaa81d4208f5a36c27ed05038e344154d6d7c94ef341d6ae7be205212fef9d442d7ac8f98e32",
      d: "27c1fe2d6dd9ade057b52ea08983d4373389b794776033e2",
      Qx: "bddc76139445c9aa10f41fa20e4988ef21d72cf0c4e4a7f0",
      Qy: "d3c29be5dee5798e925818ac1d5f087ac7a624f7237fe922",
      k: "056925acf8b40b6b9b1cb33211f71cb7b6fddb88b893cb95",
      R: "8ef40136fef6ca89d2bf4483c2b3a9f7e99e0dcf8223adcb",
      S: "eddbc4c433bcb59354a54ac1f275a192175429e382eed9ca"
    }
  ],
  /* Disabled since computed S values don't match */
  "p192sha256" : [
    {
      msg: "5c868fedb8026979ebd26f1ba07c27eedf4ff6d10443505a96ecaf21ba8c4f0937b3cd23ffdc3dd429d4cd1905fb8dbcceeff1350020e18b58d2ba70887baa3a9b783ad30d3fbf210331cdd7df8d77defa398cdacdfc2e359c7ba4cae46bb74401deb417f8b912a1aa966aeeba9c39c7dd22479ae2b30719dca2f2206c5eb4b7",
      d: "24edd22f7ddd6fa5bc61fc0653479aa40809ef865cf27a47",
      Qx: "9bf12d7174b7708a076a38bc80aa28662f251e2ed8d414dc",
      Qy: "4854c8d07dfc08824e9e471ca2fedcfcff3ddcb011573498",
      k: "a5c817a236a5f7faa329b8ecc3c596687c71aaaf86c7703e",
      R: "354abaecf4361fea90c29b9199882edf8573e686a813eff8",
      S: "80f50000ac86111c9b3047385a15d78e632c58b7949e82c1"
    },
    {
      msg: "17cd4a74d724d55355b6fb2b0759ca095298e3fd1856b87ca1cb2df5409058022736d21be071d820b16dfc441be97fbcea5df787edc886e759475469e2128b22f26b82ca993be6695ab190e673285d561d3b6d42fcc1edd6d12db12dcda0823e9d6079e7bc5ff54cd452dad308d52a15ce9c7edd6ef3dad6a27becd8e001e80f",
      d: "e586581cf94fc8be2b9316aee98b42d9d3f446153019f297",
      Qx: "6fe0202a08d773cf07ece7b14335a8e4943f5662a906718a",
      Qy: "98afcacaa5ca89a3a645156234b3b463496c4414ef7198fa",
      k: "06575ab99793a044f67597c43088749723ac7ef65ee3011d",
      R: "43e4113f185064fc46a4d95248b6bd3c157173c13d63a4cc",
      S: "4603d99289017408b889aa49b04ec5c7bbe245e6ce01d5e9"
    },
    {
      msg: "db0d31717b04802adbbae1997487da8773440923c09b869e12a57c36dda34af11b8897f266cd81c02a762c6b74ea6aaf45aaa3c52867eb8f270f5092a36b498f88b65b2ebda24afe675da6f25379d1e194d093e7a2f66e450568dbdffebff97c4597a00c96a5be9ba26deefcca8761c1354429622c8db269d6a0ec0cc7a8585c",
      d: "8068271d4019a978ad6a5b642cf20c40c7318ad1b56be09e",
      Qx: "11b8fcb620b3a40814fce73487628784f1724580c3e262e1",
      Qy: "bb062057ce3bf1c43eeced0c952cdb45ea5672d43537bf07",
      k: "e58863ea4eef46c3448107c37875c38f811c9171dd63466d",
      R: "24613dc9e28b26092cb07696d5bdff019e6f3f85498bd240",
      S: "e727ac11d6e499674771e37bd7c32606befb0a49e27c3876"
    },
    {
      msg: "47c9deddfd8c841a63a99be96e972e40fa035ae10d929babfc86c437b9d5d495577a45b7f8a35ce3f880e7d8ae8cd8eb685cf41f0506e68046ccf5559232c674abb9c3683829dcc8002683c4f4ca3a29a7bfde20d96dd0f1a0ead847dea18f297f220f94932536ca4deacedc2c6701c3ee50e28e358dcc54cdbf69daf0eb87f6",
      d: "c1be68b712e2f0ce5f2fb2b854e5566e0e220c4917ed1d50",
      Qx: "e165cbe844fe05da8ac0109518a936998a7e557338a0d879",
      Qy: "05e328de91aac88ec30daf08dedf260021c06a3a42c5b091",
      k: "523977b6a35111c673241cadbf0a441e1df2693f8b0a397c",
      R: "d32d60408aac53fb922180940171dd7f36edb3f51627ac0d",
      S: "1b4c853eeaadcb703c534e9dadbfabc4f2c5ea35734fe398"
    },
    {
      msg: "f15433188c2bbc93b2150bb2f34d36ba8ae49f8f7e4e81aed651c8fb2022b2a7e851c4dbbbc21c14e27380316bfdebb0a049246349537dba687581c1344e40f75afd2735bb21ea074861de6801d28b22e8beb76fdd25598812b2061ca3fba229daf59a4ab416704543b02e16b8136c22acc7e197748ae19b5cbbc160fdc3a8cd",
      d: "97ed7b71cfd2e54fcbc3405eb1954fad518e8c6df1b39310",
      Qx: "c206a5a204c0e679a1f91774c0abc5d33f9f0034343302ff",
      Qy: "096ae846244aa572e1af1758af11e034b7424e05a257f433",
      k: "96c912c92254cfa88481762356029ac423633a5c1ca31f3a",
      R: "adabac1edc082f49e251549a142c91e4d6b8371fc1dab450",
      S: "d0db4f9c8510e729e6ba384e2a7ed38d3738acb227ede72b"
    },
    {
      msg: "1bc796124b87793b7f7fdd53b896f8f0d0f2d2be36d1944e3c2a0ac5c6b2839f59a4b4fad200f8035ec98630c51ef0d40863a5ddd69b703d73f06b4afae8ad1a88e19b1b26e8c10b7bff953c05eccc82fd771b220910165f3a906b7c931683e431998d1fd06c32dd11b4f872bf980d547942f22124c7e50c9523321aee23a36d",
      d: "0908bba29266577f6187279b4e7b89c69c3c0a954c9b953e",
      Qx: "57dbac4f83bdccfe81d34be27df0373c7da17665a69812ac",
      Qy: "3a4808e9c027b2a1aa19e66ab72745f6607ecbb67cbf7dea",
      k: "62e18e8b5fa1e1c3b12e51d469ee571eafb72de51c438dfa",
      R: "ac16cb38f2b94478a2525cd3ae812fde821814ecc4727855",
      S: "ad67bb35a0bd238b703455fbe540e65d2d277c338c83ead5"
    },
    {
      msg: "18e55ac264031da435b613fc9dc6c4aafc49aae8ddf6f220d523415896ff915fae5c5b2e6aed61d88e5721823f089c46173afc5d9b47fd917834c85284f62dda6ed2d7a6ff10eb553b9312b05dad7decf7f73b69479c02f14ea0a2aa9e05ec07396cd37c28795c90e590631137102315635d702278e352aa41d0826adadff5e1",
      d: "cf86e30f9fb18c6b916a09ba6acf0ef6c05035f0b5153be9",
      Qx: "fb7df2c9e1196043602b42812c08c57af7f5900bdeac1a2a",
      Qy: "b9719048ab366a7f1e1009ca85d568cace9c058ccda1036e",
      k: "746f6dd3558d7ff42930cb00de422529670405de2544da03",
      R: "bea8ddfa0a420568b2dbd19b6fc16abf7a63ed66c0f67525",
      S: "bd8cd2940b16a059c1e13741d570048485aef4a9744add7b"
    },
    {
      msg: "a5290666c97294d090f8da898e555cbd33990579e5e95498444bfb318b4aa1643e0d4348425e21c7c6f99f9955f3048f56c22b68c4a516af5c90ed5268acc9c5a20fec0200c2a282a90e20d3c46d4ecdda18ba18b803b19263de2b79238da921707a0864799cdee9f02913b40681c02c6923070688844b58fe415b7d71ea6845",
      d: "8f7864b2b4e0f6135516d1b00c867953d4523571a1329e7b",
      Qx: "92c464d40fce53f22925e65ecd50baec49b49b156ced0b85",
      Qy: "f71ce3b80edd67419d73c1c54c07309e4b644fd67d4022ec",
      k: "12e9360f731d5c1d15a0e68b0ddcd80db51a76d74cee6dbe",
      R: "58fabec32dc6c1442220f34f121a02ab7a86861f7f393008",
      S: "54c7a528d3a347f5fe67ed50a58453223a3ae7e0780459ca"
    },
    {
      msg: "13ad0600229c2a66b2f11617f69c7210ad044c49265dc98ec3c64f56e56a083234d277d404e2c40523c414ad23af5cc2f91a47fe59e7ca572f7fe1d3d3cfceaedadac4396749a292a38e92727273272335f12b2acea21cf069682e67d7e7d7a31ab5bb8e472298a9451aeae6f160f36e6623c9b632b9c93371a002818addc243",
      d: "5e3c2eae83ee1bc82619c86a95524c288919e9de4ad0a521",
      Qx: "ad0220c8fe6382401da98abfc7671b56cb7b3b7710220316",
      Qy: "36b323c85d0116c892b7775e505327f4e4d2dacf03618549",
      k: "d09fa3ff3cc8595065ae3df5c500b0e9be2787857e47f14d",
      R: "6f63ce464eb669e6adc8861c48bfc9e93ca2fa3ae9ada322",
      S: "3b21e66324a8ae892c84550b185eea0ef488b78984d1fb74"
    },
    {
      msg: "51ad843da5eafc177d49a50a82609555e52773c5dfa14d7c02db5879c11a6b6e2e0860df38452dc579d763f91a83ade23b73f4fcbd703f35dd6ecfbb4c9578d5b604ed809c8633e6ac5679a5f742ce94fea3b97b5ba8a29ea28101a7b35f9eaa894dda54e3431f2464d18faf8342b7c59dfe0598c0ab29a14622a08eea70126b",
      d: "29ac61422184d4e49b867afdb3eeb2f40df2e0bf3186c6ee",
      Qx: "caf6a582fb6893d6b2ea4f7a15d2d43d91b7abd421137b54",
      Qy: "0cfff44522f49d999d052c09baeb599bb626cafe4213dc34",
      k: "d4d3f9319ef50bfbd0981eee2784394f613cf15b7d0ddd85",
      R: "d5dea485b93d307ca9b0627515d41593a2370d76571be031",
      S: "918749590bcc4d66c38f3a21bd1b1017c1819048ffc29e97"
    },
    {
      msg: "678b505467d55ce01aec23fd4851957137c3a1de3ff2c673ec95a577aa9fb011b4b4a8eb7a0e6f391d4236a35b7e769692ace5851d7c53700e180fa522d3d37dbaa496163f3de6d96391e38ff83271e621f2458729ff74de462cdce6b3029f308d4eb8aef036357b9de06d68558e0388a6e88af91340c875050b8c91c4e26fc8",
      d: "44c91536b0467b4573cb595cc6b63939f0b8cb72d312b94f",
      Qx: "12371709cdb69ab3f7fa265a8e5cb51ab6064e5b42beb536",
      Qy: "0260baa0e798d6954089e29415d994fc7954b4a313f01c54",
      k: "deefe91e65253874cc3b4f45e070f2f138ddcc0fd73c80b9",
      R: "a3d57616b4d6f727b05e3f153b7e19bbe530d186aabc36da",
      S: "49cb35e66517c5edb31dff59a35fcd8d0d32dabfba9b2135"
    },
    {
      msg: "9bf457159f0d44b78d0e151ee53c41cecd98fb4e4129fcda8cc84a758636f84dcad9032f3ec422219d8a7ec61ea89f45d19cab3c3d451de1a634e3d2532231bc03031973d7150cf8e83d8b6a34f25fc136446878e3851b780abdca069c8e981b3ea3f1bf1ff6e47a03f97aed64c1cc90dd00389fa21bb973f142af5e8ceccef4",
      d: "3707138933f4a3db2f593bc0984926abe3c8e0eebae679a1",
      Qx: "3eba27ffb523f41eb12c897e088e0e94b585e79049dac687",
      Qy: "b3bc45b84cf04134e63567070a0f52f8c178e0e4a981a24e",
      k: "042d9ec80b96d1bfd4bbe29c5fb834c4c6105f738edd9f5c",
      R: "19aa98a7bf513140e315c855c6af330e422e07f3538e7b26",
      S: "bdc8b26834e858b265ed6f4262c7ecbe2377ee31bc85a074"
    },
    {
      msg: "2469172b7a046e6112dfe365590dfddb7c045cccd4ab353edc3076091aad1c780a9a73ff93f3dbf9e2189c5d1fdd6f6167d0ae8cc0f53dc8950e60dd0410e23589999d4ce4fa49e268774defd4edce01c05b205014b63591a041745bfffc6ae4d72d3add353e49478106653cc735b07b0fe665c42d0e6766e525bb9718264c87",
      d: "d1e976d6a5f85a37ef7b634cf15dccb833ca32d28e773ab9",
      Qx: "f1def88f6dd6d00b1d5fe95eb7b4e57e13ca0afb33306bf6",
      Qy: "d62dab1905aa12770f89f20db798d398b197e516aec5f27e",
      k: "4d1e4c4f4ff06265239860e0c8dca6e59feff6bc83254788",
      R: "9a34c019e389c1b0515bec0d7d85a4f6ed92c16656a355ae",
      S: "38be91be075f1a30e2e39fdec3a40a1262d69b8d137e588c"
    },
    {
      msg: "6f8983e74f304c3657cffde0682b42699cb2c3475b925058ff37292c40a0aa296690ad129730339ac60cf784225b2fd3db58297c8ce5889df7a48d3e74a363ae4135e8a234cab53ca4c11c031d561a6cf7dd47b925ed5bc4c2794ba7b74a868b0c3da31ff1e4540d0768612192a236d86f74fb8c73f375b71c62f1648c0e6126",
      d: "2e646107f032b748be926ce821fff561d74c459cbb05919a",
      Qx: "8956649fb58bf819b6f5ff11a6f1179c563bce240178496d",
      Qy: "3b346498bfc7253e9e54ddeef3cf89335ff84befe91dd3d8",
      k: "6a32a8a540a1d1992036cc5d9413ffef55e8d04bffadf806",
      R: "f2dcca32b158303267ab039b128eae3187459536ef63cf77",
      S: "b438390ea65ec12bb7bb6c9da5dbb095e747c9229803ab87"
    },
    {
      msg: "6fbe6f0f178fdc8a3ad1a8eecb02d37108c5831281fe85e3ff8eeb66ca1082a217b6d602439948f828e140140412544f994da75b6efc203b295235deca060ecfc7b71f05e5af2acc564596772ddbfb4078b4665f6b85f4e70641af26e31f6a14e5c88604459df4eeeed9b77b33c4b82a3c1458bd2fd1dc7214c04f9c79c8f09b",
      d: "70da499b104dfbcf883d222d06e7d0597f1d276af4650476",
      Qx: "7fa0b6437ac2191048e7f8ea85f72fc04d952aaa8ad4058a",
      Qy: "b7c10d055c5814e6a74337fd0b18d9e947f5aa6cc298c1ca",
      k: "5a7d2207b70ea7e7c3d5ab5cf6ed4aefc1d43958db1f18c7",
      R: "8f65321799fdab0dd95f21df968c04a214fc782144524b4e",
      S: "23750f05a4148a1b551bb1bc89334bc505b8a9ed9ff5780d"
    }
  ],
  "p224sha1" : [
    {
      msg: "36c8b22986487f677c18d0972a9e2047b3afa59ec162764ec30b5b69e0630f990d4e05c273b0e5a9d42827b695fc2d64d9138b1cf4c12155894c421321a7bb970bdce0fbf0d2ae8561aad8717f2e46dfe3ff8deab4d7932356032c15130d599e26c10f2fec963031ac6938a18d664538b94dac5534ef7b599424d69be1f71c20",
      d: "97c4b796e1639dd1035b708fc00dc7ba1682cec44a1002a1a820619f",
      Qx: "8a4dca35136c4b70e588e23554637ae251077d1365a6ba5db9585de7",
      Qy: "ad3dee06de0be8279d4af435d7245f14f3b4f82eb578e519ee0057b1",
      k: "ec2c2faa14bee0169b2fefdd41bb3e4c39c7ac52bccfbc3091084f0c",
      R: "147b33758321e722a0360a4719738af848449e2c1d08defebc1671a7",
      S: "24fc7ed7f1352ca3872aa0916191289e2e04d454935d50fe6af3ad5b"
    },
    {
      msg: "f7e8d5552054565c07249bb5a186292a587a0bfe3d15fc7da55db87fdbd87a33982b04fcb188a499151f11c4cdaa6fcf8a71b7f07a0030429a4004b96e0ef0c04b3349524b60c89fef99dbe0e51f1d5784c485fbdda40096ec1993d238aba02456599b34bc0036be376959d9d60c5ab581580719e52a6a6f63203ecdb3966b48",
      d: "e6f0a6ab81b7bd50dc5581b03d43308fb28356408392e29a5321ca7f",
      Qx: "c87c46fb7a07789aa352d0055b3a4ad588851a80f6f0915ab5547dda",
      Qy: "b7741b39048588bae158f2568a4c1dcfbc0843210f2be6ce3e2ffbe9",
      k: "6b8c3a59ff56793cf3fc434abd01c7eb91cebbb01dd32f484b7deaf1",
      R: "8c0e764cffd1845b37ad0eb3337e06bee7265c298056d9009845a301",
      S: "84fa1e38c2911b575f33916bcbac7f63dd219ce59a31674369316fbe"
    },
    {
      msg: "6a8c6c3581223c02ea7383c905fce25d88d4fdf5b4fdd954ba98a0ebf6ccdbd7fe9dacd351ff5821d40d89fa1f7cbbbdd79952021947f34d581e4f66dfcd0205b808bc5f5bfe598574a6364eb51a0d5218691df58f9cc32dd8ec02e01521b382671fcae10e1fe6958794f49a9327b132c512ecc044bdb05a54f5c1f1ff445808",
      d: "3ad83662320c54cebad24be5de2ecbcbe30c2b69aa639ebe44a23654",
      Qx: "599b4847fb5c02b17918f8aa9547e4b0a34791ea4d96741a5d9ff29a",
      Qy: "55df76239cafa86fd149d2fa4438d54cef61f2e7d9afe3644b71a61f",
      k: "ad0ced62c01ca30b93432c142cc9d2f53ee2da76c2123c90f7ff1612",
      R: "5e034661375dc3cab74000c0589f759e1dda76756f718d47c3f026d8",
      S: "35cc2bad11d1bd6a94717add49e42064bc0b392ee9d030f2d03d3b7b"
    },
    {
      msg: "54a819f20462afdd1e171c6053bd8bc3ec536003bc2ea3b383348c74f57ab366d9f443b394f7c6e9cb689aff32fc1c5203155a41a3978401699c2cfa48341b43302c113adeb1638616a48d2b610233579eddc39eff3dd729e4b0959f059850efc5e315a108ad113b336d09a8b1450f28a68e31fc5b46e6561baf329df063312f",
      d: "9ac287e839788adac320d3157d36ed3f41e558381573a14d49afb201",
      Qx: "e78a4ba07da5c9d87b13a0cd887fef963371588ac8e7a504aa1dad07",
      Qy: "5199690b267b213e2b9c8e2526a7cc5ba0d4b25c96d899db1eab8f24",
      k: "2ff3761eb86814c4e761cd4db17369b6ab1756ca15a87eef6c18c013",
      R: "c3a7a23bde22c267e452dca6af88d9cbff80e332859149d48af47807",
      S: "79f1b5cbd6a145f6eb4582d303ee35d3ea7e87d8b64e5fd0f8a23bf0"
    },
    {
      msg: "91c123a0fce6aadf85ce7588f58831c6a7db8b8535344dfac001fc9a111c5f71223d47c05b14e93caea536e8b729c0442d648a9bef5fab5cbceb44b58d5abdead7bcd834c0f42649000c8c04af20f077257669aacc9332c8c51da05c26c15f2f2d34483f88c7fbb17debc0e59cad817446f8c0349e89baa895a0e4a5cb05f2be",
      d: "4af8ad116c393082f245904b1e062ff32a818cf0d9974ad8046b363a",
      Qx: "4382782a6cea5b369c5117953be775d1e34254b0cd322f6e58a7f7da",
      Qy: "4a089a411ce60f1741beccd97e0747b8724609f5a74154e36ff6e456",
      k: "1152259df488702133982228bb54011fa0086a7d2b8a3cc3b617c232",
      R: "342eae8c8d8bf062957be48f8792fab4cb9e654bd8592ba4ad2e98b1",
      S: "5bf0f7ecdbbbc28b18619ad2cc6bbd8c20085fd2ecce7440f362f870"
    },
    {
      msg: "5d896c51eb12e8d918ccd91d5d23e22a4d4d2568db96110dfac0f11050f82582eb740177895fc025e823a4ea15ec297458d53fff0be9c2c94284de51296e2181604eb08df8741d6825d3e5e0c94780f1403907be494de1908e3ea8733535fe08bd935ff6561d58e8fc0068f1b3b00f7014bc085a0202107a11b5c03b2e1adf90",
      d: "2d90465e11c6ee4104f283ff4019779c5c9d5d0665e8552c6d58eec5",
      Qx: "018f6cc36154151b360c47372935b1a7bcd64aedf495f1cbd3b567b9",
      Qy: "327dd3de098555ade51eff8bcacdab04fbc309ea10b77eb0576bd525",
      k: "8b3157d48a85f452703e02c1079147515a6ae139564ec46eeb9d42d4",
      R: "ca135626737544d52bb5d0722f4709633a4182205da4462c4166c54e",
      S: "fa85f1954fa02631223267320d572c7d6932d6ed2da26edb1e7dfc93"
    },
    {
      msg: "4fbeddb09d2a2d050b9b8221b5fb7b4f44a8fc9cfb6a48aa3a16d0c3620d1087848d6a494b45c939ace1a31241b69f92787e4a149676c7fadeca3288ed3873c88485cd73dbac4d75bbb32a984d2ab045b518c54b18303791e4dceb70b0df4a770d66468ec84dd0af08fa402ae27e3903877f6091ab52d913d09e17cb08ceb0c5",
      d: "6ec68008dfba890356284849d5529d0a7405fb10c9338ff2092004a6",
      Qx: "cc6959a5b591042c75fb99aa4687d33de1aab404d4c2e022d081865e",
      Qy: "4b84c5499d0003ee9d751d1bf27a6a27ab073ca4c6f5c36a9bd95ca7",
      k: "6724264dd8c92f01fc0cba26561ab5f7dd4afd1d532c61d13da8a38b",
      R: "b0cf97ad5a79fe55a67fb22f65c64dbce7482f6b6e138fe192d89352",
      S: "3b1d9236807ed766d2d776a1320b08fd8b080c2fa1b387863d2f2bf0"
    },
    {
      msg: "20a7201e4fb67e6962afe8101a9dceca2e8acb761ff579ddb54bc5935a8bc3992b1dc16a6d3b4b9d0daf1b5337b757564a2205effb2b4e7e38dbbf1019be193fa26472d5486001042db93838a58ec877331b323cc15a2ce307f83d2f921edf474c3c6fe25dd33d3e0e92b13c67c92ed1ca0c700c66b7022fc2ebb05671c422dd",
      d: "26b872a198bd4f39f9eff3d6038b49cf067611dc4e684ef24c1cf343",
      Qx: "c0f92b4452ec4286fbc0ebbf9fc4d73cb8cc52bd9538758ee739bb06",
      Qy: "54cdebd20767de663d66664e59c591c28adfb0322a5bd1898041c761",
      k: "2ad9e0e87c3e206554eac70ac7afbfa7999c93b73892fe8a1174f803",
      R: "3858452d69773fcca5c7bae0e678ba698c6eb90b8f34ce9922714156",
      S: "b764be3a2d2dd339ac20306c83302e4f803aea6d70b0a7333fbc1af3"
    },
    {
      msg: "dea90090619b70c5feecb05968b53e56862a6fa0f83e5b3e488214a1b4bed309e15c528c794d0ceb576faf6b159661512b0d2e53c5ecfdf6beada6240c7204ce185b124db695e4c5aa2824cf08c3e153c9a34c8ee426f1c403133ce2e3f9ae2fb63ee9cf0376ea719604a01a00aeb5a7e3d8d2e9690d5ceecd69d3aa43106ddb",
      d: "74cac3c4683b5b848832ce2c3157d1f4748ae2942a04f17e9c612956",
      Qx: "8c95776235855bfb6c8a5eba977e1c566b08dacb876c456e86be1edf",
      Qy: "173732acf0d6b7a51ec3d66843a3e3b896000c00206032b3c8a59ef6",
      k: "174e19ac43ca1185d14cc1270bfd0f4ad99c3c54e75ed6aadc940b56",
      R: "b41b4d49107cfc8ba2c57e0fee8df879fb7708cfbc6e18d19ca5986a",
      S: "cb90854db55a7250b444a205d0e61386d98504222e407f4df77dd1c7"
    },
    {
      msg: "fe2f9c5da89c29f4799017a04332b01d26f843b79e7855c40b7f0240cdd71726ba66574e40e251b8994af08871eda1384d4a9f3d62bec0648fea92a7661d5ad6a9a7758f88ba979c4d97ff47774b6c9f246d16edc21278feeffd678dce359c4ad2eeae1bfd216384389c35382463c088ef90fb9e076b4213a28d52213a0302ff",
      d: "c6eb83bf50449807dd1b12946b4bb29aba4ccfd1fe9ef0203fd3440f",
      Qx: "3e34fb08853c03394725fc4d8e7828ef35a25fc3612d1012faa55fcb",
      Qy: "6ea5333bfd8fc1ad3a06e947c6c60f9eb17b357411bb4dff19cb6455",
      k: "fc8909a9538102c552a310455e1d42300b2b5df5352da8ba963ab4f6",
      R: "e4fb3762017cc4a9a5865b65d32ba3c4244203d66aabde8b70ec554c",
      S: "fbf058a0a4a3f353fe8a47d87bda4eba032d8d858aa2810852a5d3c3"
    },
    {
      msg: "87c8aa1002c54ee6fe06364f19066ef3b497d0c757c8dd064e2195465e1098c6abe51a53adb2fbff617bde2365c822cd6d77b4baf0753f09f36d86e82ee68b3aa5ffc14ccdfb78ef28c03fa2f6808d9b044ce4dc2721933b9a60838a4a1de812472e10d0c8048244fe0b7fad35be655d398f212117e99c4c1e92c68adafee018",
      d: "b89acbaa56807917b4d1325858a1d28993d8090808048a559ddcd343",
      Qx: "dc0ec9cf7bcaea4fcb1a925283fba8bfb515d8291fdba232b940bc9f",
      Qy: "3ff17baa9c1a073fb157838348c5ac7afcd3f30bdf7e46d4441e9100",
      k: "a5bc0af44d19b4f15ce211e18601c42f936b4b27690b8e27554ab2d6",
      R: "b00ba15426a4c901815c3bb39ecec7d62ed4dbe68afa1cfaff6ef5ab",
      S: "24c554d7582ec1914bfbe47cf37302281d34b9f2d147d612a323988a"
    },
    {
      msg: "5839a755837138ddf416b44935a4e90030197623d9276dc21715028da723798f1e5c1c9e3968accd137af7c51838820026c2c59027ff8e66a19ee1b9b77349851fe0fb6999be6a0b196f7ee956c7b4681678b591890202e5d7a9d0b3032514400f9ccee46dd9551c4f8e8714f767a361344585d0d4cc130ebf14f8e09391982d",
      d: "19c9cbdecd6a0ab775c4101efa1a009efc2865a384ce232f8ac1873e",
      Qx: "d408006358326ea2e39ab7f75046421d4f18b1472b465ea331ef0be5",
      Qy: "cc2bb31b02f2bdf05937832f88f40969203dd1eabc4c3de069353002",
      k: "ffa43b492bc3a12d19a75736f43a3a9c553c9013ae9c5001e5b7e91f",
      R: "56c3818a5b984402510fc76a0d65e1737507e75f68a1f35a1eb659da",
      S: "200e30e262d1de79c1c5daef7bede98f27640f58fb64a481ced7b40c"
    },
    {
      msg: "7daf713b5b4928ee2c0ff34b2593edfa1648c1a591177aca21a4c1579eb2d34b4879366e30740aa0e25079bcaa8cb594e7069ecb40a5cc27426bfba61418fd914e6b970e187fdc3c3432f7f6e56a1e0e5f94c7548d4b3c02d1c27b08a62a0d767e736424cf4b725e3387bcce8f61f39413320a89eed66f7a6d714365fa8370c3",
      d: "41bb33d169c75ccf8ba2d5f5138fb5b6be4dc8fdcf53a8fdaa9cea72",
      Qx: "adc321cdde54c94dd2920110306dadae6d044e2a8465e5beba4ef31a",
      Qy: "35268278c46b10b6707ad4851fd29dc628a7e9a50d196792161b4123",
      k: "f92f6761a1e75398f973a25446a0f911ea8c15fce70f12094bd903da",
      R: "cfeb641116b847df61e0f5a7fc80e1abd5d80db20a4b0552a13b9be6",
      S: "a686585af34bdfb31eaa1b2fde99a70a18c7b10f9d5030c01ca58b5b"
    },
    {
      msg: "c922c34ae89a5e1a04d3dd6ff14dd15a1cbdc76aeb1d12635dfd68f697ef92b8daabec0b3144353e62b71b3bbbeb2878eeccaf037685a87f6d2f0e35ef7fec1a1d58ced46f80dcd2d63e84d5f100d0adfbe6d6ae2931f6de60aae385180a6e052b06d65d1dda3f76f6e969a96b71a9045a08657d934718f6ebde50777fc2c601",
      d: "36dd2974e764b3993477e8474f47f8aca2d3da794cf3ed76d59e42b2",
      Qx: "fed38c8e1c25d007b52db3acc1a4f99d034361da90793e4ae41b0615",
      Qy: "9d47e70bd09b7753f82fc0e65182003afddf4e2240a14cb90bdd8df0",
      k: "8016776fd06bf32ef2a36a43ca4a058f996f4d5a17b6a8aa8ae993d1",
      R: "cb3b22063fa972f182a2d2fc70ebf4d7e1aeb44311fa8bc197c9f9d6",
      S: "3bf46f9a772a0d39cb98a92245f01581146263f2c156d1dbd9af7c7d"
    },
    {
      msg: "553a6188719d0057df4fa606df0f2465488eebc5cdfd6a7f099f8b9d8ac4ff3e77806d4bdbda6b2e3621d1f8816615dd2b5f32a28b1595651aa3229ed867f35e0f0295495f368f036a6260c68a436f83b59dad5e96049364ae3aebf3446699d2a68af5fc3d80952807518dc7257cd9b4b4bb91ab33d90a40c411a92bb15df285",
      d: "6d423859ec293329a02a55659453059f130be9f70b38be8bc57b181e",
      Qx: "d08540ca06c7983b0555285b54998a24c3c9c5cd3d643e817ef9b9c8",
      Qy: "7127da72ae33847679078dfba12876149c86aa9c6daba21dec640c85",
      k: "8f303b3ac9d98743633bf78821d5c81cf4403cc003027dec48f6d072",
      R: "e7bad54f956844dbd72d77bc6a3a8912afef8d92780816fc6b8a7407",
      S: "881783cbda0827c0daed689fe088fd63931b9d07d151f660adf5717b"
    }
  ],
  "p224sha256" : [
    {
      msg: "2b49de971bb0f705a3fb5914eb7638d72884a6c3550667dbfdf301adf26bde02f387fd426a31be6c9ff8bfe8690c8113c88576427f1466508458349fc86036afcfb66448b947707e791e71f558b2bf4e7e7507773aaf4e9af51eda95cbce0a0f752b216f8a54a045d47801ff410ee411a1b66a516f278327df2462fb5619470e",
      d: "888fc992893bdd8aa02c80768832605d020b81ae0b25474154ec89aa",
      Qx: "4c741e4d20103670b7161ae72271082155838418084335338ac38fa4",
      Qy: "db7919151ac28587b72bad7ab180ec8e95ab9e2c8d81d9b9d7e2e383",
      k: "06f7a56007825433c4c61153df1a135eee2f38ec687b492ed40d9c90",
      R: "0909c9b9cae8d2790e29db6afdb45c04f5b072c4c20410c7dc9b6772",
      S: "298f4fcae1fe271da1e0345d11d07a1fca43f58af4c113b909eedea0"
    },
    {
      msg: "1fa7201d96ad4d190415f2656d1387fa886afc38e5cd18b8c60da367acf32c627d2c9ea19ef3f030e559fc2a21695cdbb65ddf6ba36a70af0d3fa292a32de31da6acc6108ab2be8bd37843338f0c37c2d62648d3d49013edeb9e179dadf78bf885f95e712fcdfcc8a172e47c09ab159f3a00ed7b930f628c3c48257e92fc7407",
      d: "5b5a3e186e7d5b9b0fbdfc74a05e0a3d85dc4be4c87269190c839972",
      Qx: "897089f4ef05b943eeac06589f0e09ccc571a6add3eb1610a2fc830f",
      Qy: "62ba3f6b3e6f0f062058b93e6f25b6041246c5be13584a41cae7e244",
      k: "5b6f7eca2bcc5899fce41b8169d48cd57cf0c4a1b66a30a150072676",
      R: "f12c9985d454ffbc899ebbbb6cf43e3debcac7f19029f8f2f35cce31",
      S: "12fcb848adbd8b1b4c72b2b54a04d936e4a5f480ae2a3ea2e3c1baae"
    },
    {
      msg: "74715fe10748a5b98b138f390f7ca9629c584c5d6ad268fc455c8de2e800b73fa1ea9aaee85de58baa2ce9ce68d822fc31842c6b153baef3a12bf6b4541f74af65430ae931a64c8b4950ad1c76b31aea8c229b3623390e233c112586aa5907bbe419841f54f0a7d6d19c003b91dc84bbb59b14ec477a1e9d194c137e21c75bbb",
      d: "f60b3a4d4e31c7005a3d2d0f91cb096d016a8ddb5ab10ecb2a549170",
      Qx: "40a4ab1e6a9f84b4dedb81795e6a7124d1cfdfd7ec64c5d4b9e32666",
      Qy: "83aa32a3c2fc068e62626f2dafce5d7f050e826e5c145cd2d13d1b27",
      k: "c31150420dfb38ba8347e29add189ec3e38c14b0c541497fb90bf395",
      R: "bf6c6daa89b21211ea2c9f45192d91603378d46b1a5057962dafaf12",
      S: "cb6b237950e0f0369323055cd1f643528c7a64616f75b11c4ddd63c7"
    },
    {
      msg: "d10131982dd1a1d839aba383cd72855bf41061c0cb04dfa1acad3181f240341d744ca6002b52f25fb3c63f16d050c4a4ef2c0ebf5f16ce987558f4b9d4a5ad3c6b81b617de00e04ba32282d8bf223bfedbb325b741dfdc8f56fa85c65d42f05f6a1330d8cc6664ad32050dd7b9e3993f4d6c91e5e12cbd9e82196e009ad22560",
      d: "c8fc474d3b1cba5981348de5aef0839e376f9f18e7588f1eed7c8c85",
      Qx: "66f49457ed15f67ed4042195856f052fe774077f61cebcb9efddc365",
      Qy: "3a6e3f3423eec7308a69eb1b0416d67cc3b84d24f251d7cbdb45c079",
      k: "5e5405ae9ab6164bb476c1bb021ec78480e0488736e4f8222920fbd9",
      R: "7b7beaf9f696ca1a8051527478c4c075ab45aa4768937886dbf38618",
      S: "93d4cf110a37c5a6f15c4e6024822118539e860dee2f60b8c3f462f6"
    },
    {
      msg: "ef9dbd90ded96ad627a0a987ab90537a3e7acc1fdfa991088e9d999fd726e3ce1e1bd89a7df08d8c2bf51085254c89dc67bc21e8a1a93f33a38c18c0ce3880e958ac3e3dbe8aec49f981821c4ac6812dd29fab3a9ebe7fbd799fb50f12021b48d1d9abca8842547b3b99befa612cc8b4ca5f9412e0352e72ab1344a0ac2913db",
      d: "04ef5d2a45341e2ace9af8a6ebd25f6cde45453f55b7a724eb6c21f6",
      Qx: "8d642868e4d0f55ee62a2052e6b806b566d2ac79dbde7939fe725773",
      Qy: "79505a57cd56904d2523b3e1281e9021167657d38aeb7d42fc8ec849",
      k: "ec60ea6f3d6b74d102e5574182566b7e79a69699a307fee70a2d0d22",
      R: "2fd7fcbb7832c97ce325301dd338b279a9e28b8933284d49c6eabcf6",
      S: "550b2f1efc312805a6ed8f252e692d8ee19eaa5bcd5d0cda63a1a3f0"
    },
    {
      msg: "4cc91f744ac858d3577e48813219aa3538dd813b186b42d1e6218376f07cc1cc448ddd6b37240e98bf953f49cf54d65c12878b33c0bf6eb1c60254f0b6fa974f847e53abc56773eef6f29885dfc619e6a48fc15a667ca94001a0c945b6357a53221b0f4b266181456b0d2d25e90708777f1a6f85971c00140c631c1991e0fd06",
      d: "35d4bbe77d149812339e85c79483cb270bdac56bbf30b5ef3d1f4d39",
      Qx: "7924b1d7f5920cce98e25094e40f2eb3eb80d70b17e14b3d36c3671c",
      Qy: "26c5af35f71e61858582b7cc2b41790597c53ee514ffdf7a289d108c",
      k: "751869c1d0e79eb30aae8fbfb6d97bfa332123fd6b6c72c9cd3c1796",
      R: "26bb1b92b0f01e94eba5fa429271371db527ce857abba13bd1103f64",
      S: "836aba9c63e1252c2b2d72a21e6a41b82241ebe32647e7f814652bcb"
    },
    {
      msg: "58f43cc1924de4bc5867664adbc9d26b4f096a43aca47c27c52851b006dc2a658919ef9ce5b5ac48372703be15ac51631c2bd84b88f479f113b0569a9a09e230ec1e8e573474c6075284d3e57d973829af35325d9e7dab4a5f9b065155bbcaff3642a82ef4c9b9e127d3575c050721653da3b087d3fa394192897a5519527d19",
      d: "2c291a393281b75264c9b8817af684fa86a1cdc900822f74039dc5d6",
      Qx: "18cb5826ad60e6696bf07655032a3749f6577ca36da3ccd6e66a137c",
      Qy: "194e14820fe02d784fd1363ff7a30399518309765bd3f4412d646da2",
      k: "e2a860416229dfd3f5a5cc92344ca015093a543943a0d8f73bf2b2fd",
      R: "00e300c1ef4a8c4ca5da6413856f8981db49de29bdf03f32ffc3ceab",
      S: "f250f18a51ba5f63e1584097841099fa6ae4e98ee458c061d1d5aed7"
    },
    {
      msg: "113a2806b052fde683ee09453098e402204155afb3776fd1cad3a9103421d327eab8f9ec0dd050ffcc83f93b34ea707705fabeccfe43ab1a71c95298fd3ec769d99ead1066950eee677d225816e0faad19cf69e1b35d16771689e2092cafe16d7c0dd7b0db73fffb8d0f3eaed83004dd21e753530ec939c89ba25578fa5f785b",
      d: "831ea25dbeda33d272a1382c5def0e83929170ab06a629eed6ee244b",
      Qx: "076518e393940d42dfd09819409d66966d8c9189c83d554a9cc8a082",
      Qy: "44d0ceaf4c0f50e46bea4a52e30423ce3ada19edd363ac5694c65cb8",
      k: "6be6dd9f6a083915ccba54626caf12d246d3aece0a7eda7d8d85599c",
      R: "ff1460946e06fb6f5d35e8d2625ca70ffb9b45308e3fabf6ad8351b1",
      S: "6029aa3990918e8cb8a388d53b0772e5cdfff49c3405fe0d3a95933a"
    },
    {
      msg: "64cbfc8f2e2149a31b3e8a80c4a552f6c62aaeb7990b6e0ee55500a9d17be04213406578caf315951086dff5c2af3b5ce17d425d185101ef26f86396ba3a129a4f3f8e2dd595f59efb6c0f5c2dcc394569d7268695e9ac7daa84203f1f1895f1f9e4b514a5c9cd23baa63454710144fe735ad9b8f42d8c43267aa434a26d7e5f",
      d: "70f74c7324ef137318b610ead8ddc5b964e0eed3750b20612fc2e67b",
      Qx: "279649e2a2918e683520cde3fc98b0ae58a7100e8de35e7c9cc797b6",
      Qy: "aa4de6be34be61f02880139787b9038f4554a8ef1c994b887c2974b5",
      k: "8e984864f86f7a2a73f3edda17dbccd13fac8fa4b872814abf223b1b",
      R: "3b18736fa11d04e27e2614cda03a63ec11a180f357b0b3192920d09c",
      S: "2f0f3dbd570727b14fbb29155538e62c930dd51c4035275c1365dc60"
    },
    {
      msg: "a10a11c8e30fff118d371daf824f16c08200b83ea059436466a4611ccac93b2dea2de8c1006f946196aef7fe9b0c251a391b0340f21797798278b412ff2b53842eec6450728e2bca062f8337a2c204b9ea04ff660cd4d4db559f2f11c4d8ef199021339fcc82396f7a93926cf5f247e37d8067fe50692de54f102bd5ab51925c",
      d: "026be5789886d25039c11d7d58a11a6e1d52cb1d5657561f2165b8a8",
      Qx: "3fa617c50b177da1a2bdb98b780ad21ad1195c4bd24465f6187de3c9",
      Qy: "e3fd8d8876dfd03a4a4e31a1acad3a08d983826d286c250c4e5620c1",
      k: "0128b8e3f50731eb5fcc223517fc0cf6b96cd1d2807eb4524bc46f77",
      R: "3a6b633f96f3d0b6d54f7fb29ac33709e4f0dd8fa0e51606ed9765ca",
      S: "63e8c119dfa51784decd864f6911f2210a80f8f02d472d88df10d119"
    },
    {
      msg: "b3f720bf566ffa369259f4361959ae0641d2755ec264a4c4349981df2b02563275b2b9adb5aee47f7a456760a971991ffed6b17809bb9694138d1677fa916123795239353158fc6b22d10f20d26f5d2dcd8c56c44373eea5b93067dba2d7c5318dac2e9e8714873cb1b37f58c011fd14fa1e535554efe05f468bfc8e11cd8b99",
      d: "e79c18d935c2839644762867aa793201f96a3cde080c5968412ce784",
      Qx: "b7ae1e992b1c7fde1141f40bd913358538ca0f07f62b729f13cea327",
      Qy: "811252d12120e04805fc171a439d382c43b68a21e1a0bdf5e4ec1da4",
      k: "7abedab1d36f4f0959a03d968b27dd5708223b66e0fc48594d827361",
      R: "d35047d74e1e7305bb8c1a94e8ae47cb1591c3437a3e185e00afe710",
      S: "d9c425c9d5feb776ac8952e6c4eee0ecd68aef2f0e7bff2e49c9185e"
    },
    {
      msg: "0a398a46df7ccc48d1e7833f8bbc67100f1ef77a62dc78bbc115b2a662f9591fbaaa91ad3d788e2fdd1b3164e45293d4f5686c151296901768028ac80ded4bf89c647ad35f0c7c4cb318c0c757c1d83c44d850e5fd4677281b3f13b1ee54de79c8c042813f9d3312dcc6111a68299cb7e829557d7f3d96e702f65aefc6499415",
      d: "0d087f9d1f8ae29c9cf791490efc4a5789a9d52038c4b1d22494ad8c",
      Qx: "cd95cf8fb1cd21690f40d647f2353672a1076cc6c46bddaad2d0fc56",
      Qy: "934262f74d9ee0f8a2754f64cb7415923d64bf00c94a39b52803f577",
      k: "557d0e3995dc6377b3911546dd7aeaeec62a6d8f2af6a274382fc37f",
      R: "56df0ea6afdcc232ceb41729eec00cf906b69b6e28423a36d3c92cc5",
      S: "f4f70fd948c9a147f55317fdea7b8a84c33e721014552d5800d63edc"
    },
    {
      msg: "8c33616821a6038b448d8918668977fcf1ef5aa0cf7c341837b39bbcc9bca875a3757f4b392630e9995b9bbe4eb66978b877586adaa02f99d2344dae082a7603351d8ffcfca081ab403cd0acb90d078dd1d0789c2eb3185c62bff2d9f04cd38e509e3b83c12ed0a5c6808fc42f7ba5b06acdc496c8ad9be648ee6a4505f8560f",
      d: "0830aebb6577d3a3be3ba54a4501c987b0e0bb593267b9bbadb66583",
      Qx: "b88652020e083ccc1c43dc83d1881884dd4c7e3b4e3460b344b1ea64",
      Qy: "22b69b517f86d7c26dc37c0f8feb4bb07fe876149fbcc3334fd2805b",
      k: "e4f4a3280574c704c2fde47ca81ec883d27f2c5a961a294db7cda9d2",
      R: "b30b8a0079d9a134b5e1618c2ac63e3fbe0e95866b9dbc5f423f2707",
      S: "3dc36746610271ef66e0aa52cc2ccadc5c9b08dc769e4dc4f6538c11"
    },
    {
      msg: "94d56535fd4edfe67a0daa6579f9d53bf6b7b8830ae2aeb62892ff59f18756ddf2811b449c7d20d65d54f8507de4e7c50eaa084830637812aa4b250a4d61ab67845be36e4a41cdc0a70f8d6e3a63d4514f0dc197e6486015046a316153d5f3a3a4a0ae1ed7ea5fa55e12e73d333333685c02e0eb636234ea7e6d4b76b4b76b5a",
      d: "2acc9b97e625263e8e4cd164302c7d1e078bfcdd706111a13ccda5b2",
      Qx: "ce1a06f82df874dded37cca03b56c0648e4e8917ecd40ee73ee61588",
      Qy: "ceb6177b8f1ac7c5c6e6e1f7737cc3026952ee392badd2cd7af32f9d",
      k: "e401fa80f96480d437ed4f61a783888062ec33d530b188fd48016a6d",
      R: "28674f447c4742e4087bbccfb522fbad4e18b56031d2ce8f532b078a",
      S: "a5a7a13d15b423dd17771f73cea98d89dbffa846cc209b45c0e29b76"
    },
    {
      msg: "5d8ebdf9eb28b47bdafaa36bf0b66a9eaf99b6c83959da4f2b1151b4f4ecd28fb115a64c0cb9491093a7e9b9c53ec423e4c72e7765bb9c818da0e8c428667e44474a71db4867130c77c40bfd8544b2d7b9d6464d2b8e6a48482153256a32437c3a747231f51134dd14c703407e31146a6fcde23bededcf16950486e90ca69ac0",
      d: "f4e873d4fb944fb52323406f933815092b7672221de4d1c45917f3fc",
      Qx: "0dc2cdddb990341adb1de73f02d87fc3822485a659a15145f4251d5f",
      Qy: "cf78b2a83c7352eda1af2c74e1804ea04b35f76c04e89d90281dc2bb",
      k: "5d1476c682a64162fd2fdc82696fc8cab1469a86f707ea2757416e40",
      R: "82982b38ed465138df4018d7cfb835edcb591cb57446ca49d163782b",
      S: "8ef1d7b326cabee7f7ab95b7b98d3c27a069c0fd95a1599c0ccb422b"
    }
  ],
  "p256sha1" : [
    {
      msg: "a24b21762e6edb153cc11438db0e92cdf52b86b06ca97016062759c70d36d1562cc9630d7fc7c774b28b54e31ef55872b2a65df1d7ec26debb33e7d927efccf46b63de52a4f431eaca59b05d2edec4845fffc0ee150394d61f3dfecbcdbf6f5a7338d0be3f2a773451983ebaeb48f6738fc895df357e1a48a653bb355a31a1b4",
      d: "be34baa8d040a3b991f9075b56ba292f755b90e4b6dc10dad36715c33cfdac25",
      Qx: "fa2737fb93488d19caef11ae7faf6b7f4bcd67b286e3fc54e8a65c2b74aeccb0",
      Qy: "d4ccd6dae698208aa8c3a6f39e45510d03be09b2f124bfc067856c324f9b4d09",
      k: "18731ef637fe84872cf89a879567946a50f327f3af3aaeb6074a86f117e332b0",
      R: "2b826f5d44e2d0b6de531ad96b51e8f0c56fdfead3c236892e4d84eacfc3b75c",
      S: "a2248b62c03db35a7cd63e8a120a3521a89d3d2f61ff99035a2148ae32e3a248"
    },
    {
      msg: "ac3275c33b54d4f5c4e9200191e525392e7b8f1c94f641e6bfe379ad44b88850efe76612f50652723a0eeeb1d6af1757761ab89a4ae177a04ff3af33cfc69d6bbfe7efe68ad268ff92c4385fd40f99bb2bcc3cba97a90b3db4055aadc3ad8d2d966219638afc2922e82e140a61238d90ad35cc322a3557e7a6d88010c74eb959",
      d: "1fe33950c5f461124ae992c2bdfdf1c73b1615f571bd567e60d19aa1f48cdf42",
      Qx: "7c110c66dcfda807f6e69e45ddb3c74f69a1484d203e8dc5ada8e9a9dd7cb3c7",
      Qy: "0df448986e51bde5d1576f99901f9c2c6a806a47fd907643a72b835597efc8c6",
      k: "ce45eac259171cf25ddbd621195515111c7b933de3d415f2a269648fa8b803d1",
      R: "e4337061373d22d10f8b96888ebba55036096a4d39ba1566127ed894a914bf91",
      S: "77792301bfaadc72334312a3fcaaea3bc2af5ec3065a526d04d467d07dce9851"
    },
    {
      msg: "725b4872151ab885a0c21f391a4a8b83a747d99db8a187ff1fea69c7a0427c24f295a133f398b572facdf79a661381ca7289b8e6f09387208c4485314a2f3c93dec576df55840754823bf31cf3eeea5162c7b29ae0d2e6719c6ffd0a6dc3a01fecb38161357f0abc3b0cf1abee14793651e3f30bb9b445411bc8a04607577e22",
      d: "65dee450c43c222ca453b46375e63169b389b208e9c091974f258af09b8ab000",
      Qx: "8b91da916dc268e5b7018f578fa3cefb03721a6427a918a3b754390adac76ecf",
      Qy: "6d5da492a8aea36df8418c941e0339e52d15595ad5ca52e93896697b9dc87870",
      k: "43f990dd44e86744d6e5d3107100e98a34289afd80777a18b92a40ec49b93d28",
      R: "e6aff59f9185dcb84ab2cf481388c31c5101d678370bc34e2c3adb63a7d3b899",
      S: "7aa151701e8479bd787171f6c0c0b070a50d03447f27745bc3a28ac3b82820da"
    },
    {
      msg: "d5112d558342ac908e8ff21e1c7049150ba3e4a9d7127785e96e438bdbb1ffda7ebee6c549eb236b4a782db9b7e579c9f5c666552605221da174c09a7fa9640af921f63fb5e0eaca49681b8e1b53f823145258cef907348845cf346cd355dcd6c846d8f4ab4c3b65b2cc08608c3724ff401143d0527ac947732ad4b9702dd092",
      d: "e93ec1b3a4c69ebe0843b731625bbc020336593fb86ded4782cdfa447e49ebb3",
      Qx: "739253334af6ddf935e4a07ac9a115eb2b978c93a687d438f221c54474697dba",
      Qy: "a1eeba7ab8985bc5e43a8ff886c32018b431723c2b84d8c30d284f546d675c44",
      k: "c2650705469748344ad9e08e290cab107581ffb17402e57514d362a5b0890235",
      R: "e53cad8cf4deb3ab44b603a185f4eecd50bb19cbc3bc1e394382775ad5857aee",
      S: "6663df18f6c50100983c2d1b2b0b4574ff83dd5b87a7747789402a1a6ac5cb2f"
    },
    {
      msg: "f858c9488ef60b3ebcde475cb2fb44c009b051267442c4e4bd329a67db50a1b85a4b591b191fdce348a1ee7d33eac53e43eafb79b31937ca5ca4dbf08c6330b35d34c1845a99daf01e33a71f2ab1f2923317d9892829be25437d7bdf8485eb886d3e492ea5366084f0e3102d7a3fbd4e63442e9ac70f4ac1daf740db63093a30",
      d: "1cfc39b35ef4afb8e0182f6aa5da8cef0925dd829d1e43f18caabacf3e5466fa",
      Qx: "db02762c3ffb91fdf9ef87d4488acaf5aa0c7e898004b5621ef0d3b20e7fec54",
      Qy: "d0ff019ace9b7c058f20f01355f82ad886f83aeb87770e54135572a2818fcc31",
      k: "f35c0742dff5d901326a42ca50ac50b7c32794c7d85f48a7450da772b967b8ba",
      R: "e4f877e86b6da25cfdadcd1967b98954c7c4545178769c78269975ba54734ccc",
      S: "a8676a0bdf9fbe47f16a92bbaf75821906c74f68ffca2fdf602d7f48b4ef9e6a"
    },
    {
      msg: "9f25f1faace8de677a8a67adc7eea9e93f77a98bf19429647202639bff18ee8633a8d4bc675a4fb58ea5dda044dc78d43cff74ac14149dc94367877f1e063dc3ded853c8475dcc10082b42c93256e3ade3c22623dcf86dcd28043d3d4c538f807e2f25a9b24fd939c72c3de3ad09107b327da970b9fd47045fab7c8fc5de7101",
      d: "533e7ec63dddc22071a5614409a68b3f99355de629abf2fb9dea696dd6bab1b2",
      Qx: "ca641448dc12b7fc154d9bb129affaab4f03ed5d28cc8ef47d318404b427e9c5",
      Qy: "668c5930638802ca8dbc468f2b69176036da375ca16308130a683cf610e3f260",
      k: "21ab69b8ff8eee106d6698cddaa58052bc23564cf8ac28570f4164470f3f9739",
      R: "63eda6e6a7888fc4bd54242227b60520dbec520b5538e14eec2ea5ef1ce1c298",
      S: "f6fabd495f7191d2df06a24d53748c32e014b0e456b4406769500399ed93f881"
    },
    {
      msg: "b4b3e4477d00cda57d5348ccb70e3321943024acced95a85ea5e48c1a5beceafdc61879be5f743f4b641418a9fe8823fa2d8f6222ca8c4d9f586d9f221a2dee648c47f2539879374efe1f17de0404f3bf2e7d4cc512f38baf0a9d73b5a8f969314dee5c12652ca7e2cd4a1901b7a21fdcfbaf11b9508fe6571cb296020c83ab6",
      d: "9134c53bdf5a0fb7bd1d0afab6edeb0ad7270c5efc083f3256f0cb251fca3a7d",
      Qx: "760abf17b9abdebfb8a7807d8a96e69b68caa9e5c883be8fa8a3c6140c22e217",
      Qy: "817a35e830b254508ae9d04cc9ef58f06254e6711174e3f9fcde6560b8c3a75e",
      k: "d2cfd5d47c6a3b125557d86509618859027703197bea96a483af6de4f0fbd0b2",
      R: "23131427fa930631f1dad2c8f2c96222245a0f14b2704fc87986adeaa4a25dd4",
      S: "769745372812d2a2b7d59bafa1d1276fd63c1ccfc06cbf44f3e93015191f690e"
    },
    {
      msg: "6c912febe971de66f63842507c77d68323e3eda0db15bbd169c12fabcacca45942fc5efe5e50fd2d88d81677f16d6a3ae35730f0500b276d894b398e1229edd97da0d01d7951b75eef77186fa17e0cf75f3372043bd1290a9f79a5b274adc5d08c02f7e6ec680faebe6c6127d51c03bb63740a970d5ff9940a0d807a4fa2c915",
      d: "2c678b91bc8c8f2610439bd586b69c0549847c32ef41b2d31bab4d90362cb76a",
      Qx: "392470b95de6502a2ee121d4798fec9fca025d7f49b7f5134c2c8faba1879887",
      Qy: "ec293c22cea46db8fd6a90ab3d3b1e763f6f1de09e79408725007ac4edee31d3",
      k: "285493df1f126a153d9cd79eef19e31eab3d2ece9a8898b463175680e7372d8f",
      R: "a12aad3339e291c0103974af9e77713bba63413e85f05aa3230a9c2487348f69",
      S: "8dfaf41f619807b085453a14df195d686d3d80c97602a0770da853de155da630"
    },
    {
      msg: "f44a2f163fa651803c6ccf07b13a0120265fdab908e3de4e7c30bf8c55304d6d184e654124044cc2f31441f7c9540ef732623e603039754b68fb4246ab9bc3acd6012309e650cd35bf02ee552c354938c662f5389e5ce35964e0e060ff1209ca209f1049f9e62dc36e1182f3a22b31cbd8a4ab4163bdaeac7621d599de6e122c",
      d: "1545750a9cf39b189e0fed21118c95aae771de4664552a2b36ba2cdafa072496",
      Qx: "91c50e3505cb18127a1cfab0a543df407e3189f300c03145c801f6fb3c06be56",
      Qy: "1c80d1585e045dc028c543aaff97f9dcbdc14701e6113ab2d983c703587592d3",
      k: "d74686019626b6733960263474938404c855928a0e2b3251a1fbf6e63df00c4b",
      R: "ebf0cb5e43e28aa9c209ecd1b9f95528e5820305b85c73558cc4ebb43e4cb20f",
      S: "f75770a7cb17ff659dd241ddde8dc2a79cc6a8d89203c67cd5b8243c40877d2c"
    },
    {
      msg: "58fa1c954d5b63e4637fb27ffb8d9521b756c7daf47a7b0906f53fe9a548995a03d2af43886e4bffff5a1fa8ad9087e48d17c1e6de55a0b5149e2200d14d73b3c95f74ad1708e75ac864109c6b21d8215b7c8d4d750337dff8d7f56c524dfb6e30e6637920b45a6ed052c291280e4f1eb22bde0310fc80a391325b34a29f90b3",
      d: "b24cbf1f527b4f178fccab71f5397cfac08448b9466a94ea61dfa1fcd117bafc",
      Qx: "4140dbefc6a025aa38d89fcbf493d9c9cf935285cbf6e6d46439b8b4b2b212d3",
      Qy: "39a3c27cc0ca04eb822da9bbb543d1550a00bb61b8ad6d928d03282b0a315c25",
      k: "7a4f0c2190ae1e04dc3ef9bab93a3683e9f2fddec48d93f3ca8775fc4d8943f1",
      R: "7a896ba95a27aac2f10046f07538dbfa023b7fe6164dde5fc8d4bc7e981ad291",
      S: "7698349f95ddab79c9de2ff97acff63da555cd7025ebdd0a3fe8ac37bed4c77e"
    },
    {
      msg: "bcfb424e5325b7db169d25152f845fce8a5d0c431985b48c622c1bc0306e6b2e927e1aa4a4ad49c00ac90a3dff38a48cc6a1fd051a0206c75153f6732969d0d1211cf09b573a8c04ac9c12a64d852c5417b9d28b8c4c7fa8e3588cc171ee550dfb7f73e0102e82782b337eab374ee4d52ff8951c8a6d460a4ed140e0611cdc1f",
      d: "53e2db8a5e9b560f8e1271dccb0df690f086a6d7f35334853a2a01932da42737",
      Qx: "355f248821295b1ac54d4d67c7f85ae7e9aa39f032b8bca7e300228df1b53d6f",
      Qy: "f9edc9c3b39111ea198bed4b8116b4ec04d97ac1484ea681611ff9e18997911c",
      k: "2cef19b64807559a22d795e00704e7687eef1ab69e4bc9addafdab4aac3cc25f",
      R: "3ecd9eb36b538515b9f2cd7e9ec731d11d367c2694fcce7cd8094c6eaad32f8a",
      S: "08511a693d962758434d12d76330189969e05f672f8e6d4d681880e92999ae1a"
    },
    {
      msg: "e933cce186c24ddb88754a08c5f1571c170372593e6d3b7c256c378b290a44516a71a8beea253d2110793b66958686ee475deb67a2352682ce9a3f4e02b0c71368cd8cef7d23f9b4e6c46f6e8b3b07b90fc2d499e3274d11570be39c39cbcb6f92b245be47f0d60fdc03bf95e0dc2b22c2b985df4e407485e660984715bd217d",
      d: "9691aa416ea645de2fcea9041086a62da57f6ea7771eed2d88305aec3e91ce70",
      Qx: "2bd8ffbe98b9fa4489c9345e9593626b250f492e1b6cfeb7d9fd5a63dd0e2aae",
      Qy: "ec0ed1bd59eef482e7a83d21ff01d44d0537281e23e66c3c498e3278c6a9996a",
      k: "4b5c25141913b2b08508098d713876c6379d8854fd82ca9adb55fd893587eb01",
      R: "a2f503d5d5acc9536b4c2952fdc67ffdb3953f8feb8ed05afd9db2c013e51a35",
      S: "85787a416dcee11361d3f6be9943b592f0e74ef9e1b067131aba60a4bf1cae48"
    },
    {
      msg: "129dfb15456ecd1c70e421dd5df55037f0481e80ae2694cacb702885847ee3abaadc4a0adb27075f26ee852d560723fd5bb3379aa022e8be25ec294638bdd53166d2e9ec35bc78e4d42cbc2c4b58dcd30222cbc46e56a4bd8a0dc8d7744e2e0cc3018ed25a450e12a7030963a05afdd03dc4a6a93c099f5140c65746d1ffe2fd",
      d: "f739a5d137495f5d5b6cf1eef062f0e2160940ef69c8b480505bcfa783c5f650",
      Qx: "f9cd480b2daffd9fc7674750cfe0092aa73e3e33f83f6ae81d9de18b1c7ff29d",
      Qy: "67a661d919c13bc2c4b4c65935ec4ab4c89e46e72c7430c027d56decab986ac9",
      k: "34da46b8fe9a20e59d0c6cf73750af580d60d17c731b28ab82238468cd8106a0",
      R: "6e7973338806d8885a1e1962d440c4122e685a67bb453981b0669c2788aab547",
      S: "eb7fe09a88e47ed3a49209dad4cab1eb1d5c2c3c93b7ef8e26266add4291ee2c"
    },
    {
      msg: "fa0092ea1b0ed56800689ae9399522fed95dc55e88fc9e4d4692576486c84573633bbaac30fe1554dcd9f270365bb0ec9631b0564b3d2660850befe501718cbd06d1446a4978a34e2e27cba67a37e25d0f9c0ad9ce33008844e4fd71ec21dd873e84933653a24e5aaa420ef171a8e2073388cc69013c8b2d43c6840846cd20cd",
      d: "fff2b2469b0cad0a6cd55936558f1d6af2644d0a5fc64136aa22bff38d27b9ae",
      Qx: "118ed26c29d0a1d4e85e6d5d0250464f6617aa601294891c31873e00d574fc00",
      Qy: "b6a6b61556d9c3c1175ac845915ba92acc0d84cd298aff3fec09d6162e42067f",
      k: "6c7f12ecd6224c4cfc9d5883cd34de3aa93b3a7204fe747ef634ea1ac47c3453",
      R: "459701da1b57cd4a4de43ca13438967b0e4ff07679ba73dc22f96925de645467",
      S: "f7cffdc4da23abce131c86daaa686ea56ae714c13a7cef353ea95302d5708c3a"
    },
    {
      msg: "4ddf84886629454207b770c0651a72dfaa4904044c1781a264763f1934201ade0ee11dfbe1c5749adb0ed54000f4cc59e219e2bdd6d062a0d453801121ad0fcc4d65d3b30c4b45972d1205a84c62fc3cf9b8bef989271108a2b18a0f1b4706b1172cec6a2e20a5db4fc9ba3dc200073355acaa6a5d8e6f3d2e513dbeb9734458",
      d: "a30a1a653c8ddf1b03dcccb15b96e76a9620ca7bcbb1bac3754e053fbc55c989",
      Qx: "625a8fddbcabe407bed77aa74f90fec783d955a0ccf88e81e66a1dded4196e6b",
      Qy: "d89e44f1b8a0dccd8c500f2c6a460942c56330722cb59a45d38376938627a1f1",
      k: "83fe3f656ab40a45ff615f52dcf74f0e6cbc3f3396d275abe6f0cba92ec6aec5",
      R: "7ada5e3c644fc66bb1d3967955a7d3715b760d950db88724c75568ccb1f9d285",
      S: "460e27a26e218936e9323b350090cb9267ed5794a564dfed4d3920d1d03f3538"
    }
  ],
  "p256sha256" : [
    {
      msg: "5905238877c77421f73e43ee3da6f2d9e2ccad5fc942dcec0cbd25482935faaf416983fe165b1a045ee2bcd2e6dca3bdf46c4310a7461f9a37960ca672d3feb5473e253605fb1ddfd28065b53cb5858a8ad28175bf9bd386a5e471ea7a65c17cc934a9d791e91491eb3754d03799790fe2d308d16146d5c9b0d0debd97d79ce8",
      d:   "519b423d715f8b581f4fa8ee59f4771a5b44c8130b4e3eacca54a56dda72b464",
      Qx:  "1ccbe91c075fc7f4f033bfa248db8fccd3565de94bbfb12f3c59ff46c271bf83",
      Qy:  "ce4014c68811f9a21a1fdb2c0e6113e06db7ca93b7404e78dc7ccd5ca89a4ca9",
      k:   "94a1bbb14b906a61a280f245f9e93c7f3b4a6247824f5d33b9670787642a68de",
      R:   "f3ac8061b514795b8843e3d6629527ed2afd6b1f6a555a7acabb5e6f79c8c2ac",
      S:   "8bf77819ca05a6b2786c76262bf7371cef97b218e96f175a3ccdda2acc058903", 
    },
    {
      msg: "c35e2f092553c55772926bdbe87c9796827d17024dbb9233a545366e2e5987dd344deb72df987144b8c6c43bc41b654b94cc856e16b96d7a821c8ec039b503e3d86728c494a967d83011a0e090b5d54cd47f4e366c0912bc808fbb2ea96efac88fb3ebec9342738e225f7c7c2b011ce375b56621a20642b4d36e060db4524af1",
      d: "0f56db78ca460b055c500064824bed999a25aaf48ebb519ac201537b85479813",
      Qx: "e266ddfdc12668db30d4ca3e8f7749432c416044f2d2b8c10bf3d4012aeffa8a",
      Qy: "bfa86404a2e9ffe67d47c587ef7a97a7f456b863b4d02cfc6928973ab5b1cb39",
      k: "6d3e71882c3b83b156bb14e0ab184aa9fb728068d3ae9fac421187ae0b2f34c6",
      R: "976d3a4e9d23326dc0baa9fa560b7c4e53f42864f508483a6473b6a11079b2db",
      S: "1b766e9ceb71ba6c01dcd46e0af462cd4cfa652ae5017d4555b8eeefe36e1932"
    },
    {
      msg: "3c054e333a94259c36af09ab5b4ff9beb3492f8d5b4282d16801daccb29f70fe61a0b37ffef5c04cd1b70e85b1f549a1c4dc672985e50f43ea037efa9964f096b5f62f7ffdf8d6bfb2cc859558f5a393cb949dbd48f269343b5263dcdb9c556eca074f2e98e6d94c2c29a677afaf806edf79b15a3fcd46e7067b7669f83188ee",
      d: "e283871239837e13b95f789e6e1af63bf61c918c992e62bca040d64cad1fc2ef",
      Qx: "74ccd8a62fba0e667c50929a53f78c21b8ff0c3c737b0b40b1750b2302b0bde8",
      Qy: "29074e21f3a0ef88b9efdf10d06aa4c295cc1671f758ca0e4cd108803d0f2614",
      k: "ad5e887eb2b380b8d8280ad6e5ff8a60f4d26243e0124c2f31a297b5d0835de2",
      R: "35fb60f5ca0f3ca08542fb3cc641c8263a2cab7a90ee6a5e1583fac2bb6f6bd1",
      S: "ee59d81bc9db1055cc0ed97b159d8784af04e98511d0a9a407b99bb292572e96"
    },
    {
      msg: "0989122410d522af64ceb07da2c865219046b4c3d9d99b01278c07ff63eaf1039cb787ae9e2dd46436cc0415f280c562bebb83a23e639e476a02ec8cff7ea06cd12c86dcc3adefbf1a9e9a9b6646c7599ec631b0da9a60debeb9b3e19324977f3b4f36892c8a38671c8e1cc8e50fcd50f9e51deaf98272f9266fc702e4e57c30",
      d: "a3d2d3b7596f6592ce98b4bfe10d41837f10027a90d7bb75349490018cf72d07",
      Qx: "322f80371bf6e044bc49391d97c1714ab87f990b949bc178cb7c43b7c22d89e1",
      Qy: "3c15d54a5cc6b9f09de8457e873eb3deb1fceb54b0b295da6050294fae7fd999",
      k: "24fc90e1da13f17ef9fe84cc96b9471ed1aaac17e3a4bae33a115df4e5834f18",
      R: "d7c562370af617b581c84a2468cc8bd50bb1cbf322de41b7887ce07c0e5884ca",
      S: "b46d9f2d8c4bf83546ff178f1d78937c008d64e8ecc5cbb825cb21d94d670d89"
    },
    {
      msg: "dc66e39f9bbfd9865318531ffe9207f934fa615a5b285708a5e9c46b7775150e818d7f24d2a123df3672fff2094e3fd3df6fbe259e3989dd5edfcccbe7d45e26a775a5c4329a084f057c42c13f3248e3fd6f0c76678f890f513c32292dd306eaa84a59abe34b16cb5e38d0e885525d10336ca443e1682aa04a7af832b0eee4e7",
      d: "53a0e8a8fe93db01e7ae94e1a9882a102ebd079b3a535827d583626c272d280d",
      Qx: "1bcec4570e1ec2436596b8ded58f60c3b1ebc6a403bc5543040ba82963057244",
      Qy: "8af62a4c683f096b28558320737bf83b9959a46ad2521004ef74cf85e67494e1",
      k: "5d833e8d24cc7a402d7ee7ec852a3587cddeb48358cea71b0bedb8fabe84e0c4",
      R: "18caaf7b663507a8bcd992b836dec9dc5703c080af5e51dfa3a9a7c387182604",
      S: "77c68928ac3b88d985fb43fb615fb7ff45c18ba5c81af796c613dfa98352d29c"
    },
    {
      msg: "600974e7d8c5508e2c1aab0783ad0d7c4494ab2b4da265c2fe496421c4df238b0be25f25659157c8a225fb03953607f7df996acfd402f147e37aee2f1693e3bf1c35eab3ae360a2bd91d04622ea47f83d863d2dfecb618e8b8bdc39e17d15d672eee03bb4ce2cc5cf6b217e5faf3f336fdd87d972d3a8b8a593ba85955cc9d71",
      d: "4af107e8e2194c830ffb712a65511bc9186a133007855b49ab4b3833aefc4a1d",
      Qx: "a32e50be3dae2c8ba3f5e4bdae14cf7645420d425ead94036c22dd6c4fc59e00",
      Qy: "d623bf641160c289d6742c6257ae6ba574446dd1d0e74db3aaa80900b78d4ae9",
      k: "e18f96f84dfa2fd3cdfaec9159d4c338cd54ad314134f0b31e20591fc238d0ab",
      R: "8524c5024e2d9a73bde8c72d9129f57873bbad0ed05215a372a84fdbc78f2e68",
      S: "d18c2caf3b1072f87064ec5e8953f51301cada03469c640244760328eb5a05cb"
    },
    {
      msg: "dfa6cb9b39adda6c74cc8b2a8b53a12c499ab9dee01b4123642b4f11af336a91a5c9ce0520eb2395a6190ecbf6169c4cba81941de8e76c9c908eb843b98ce95e0da29c5d4388040264e05e07030a577cc5d176387154eabae2af52a83e85c61c7c61da930c9b19e45d7e34c8516dc3c238fddd6e450a77455d534c48a152010b",
      d: "78dfaa09f1076850b3e206e477494cddcfb822aaa0128475053592c48ebaf4ab",
      Qx: "8bcfe2a721ca6d753968f564ec4315be4857e28bef1908f61a366b1f03c97479",
      Qy: "0f67576a30b8e20d4232d8530b52fb4c89cbc589ede291e499ddd15fe870ab96",
      k: "295544dbb2da3da170741c9b2c6551d40af7ed4e891445f11a02b66a5c258a77",
      R: "c5a186d72df452015480f7f338970bfe825087f05c0088d95305f87aacc9b254",
      S: "84a58f9e9d9e735344b316b1aa1ab5185665b85147dc82d92e969d7bee31ca30"
    },
    {
      msg: "51d2547cbff92431174aa7fc7302139519d98071c755ff1c92e4694b58587ea560f72f32fc6dd4dee7d22bb7387381d0256e2862d0644cdf2c277c5d740fa089830eb52bf79d1e75b8596ecf0ea58a0b9df61e0c9754bfcd62efab6ea1bd216bf181c5593da79f10135a9bc6e164f1854bc8859734341aad237ba29a81a3fc8b",
      d: "80e692e3eb9fcd8c7d44e7de9f7a5952686407f90025a1d87e52c7096a62618a",
      Qx: "a88bc8430279c8c0400a77d751f26c0abc93e5de4ad9a4166357952fe041e767",
      Qy: "2d365a1eef25ead579cc9a069b6abc1b16b81c35f18785ce26a10ba6d1381185",
      k: "7c80fd66d62cc076cef2d030c17c0a69c99611549cb32c4ff662475adbe84b22",
      R: "9d0c6afb6df3bced455b459cc21387e14929392664bb8741a3693a1795ca6902",
      S: "d7f9ddd191f1f412869429209ee3814c75c72fa46a9cccf804a2f5cc0b7e739f"
    },
    {
      msg: "558c2ac13026402bad4a0a83ebc9468e50f7ffab06d6f981e5db1d082098065bcff6f21a7a74558b1e8612914b8b5a0aa28ed5b574c36ac4ea5868432a62bb8ef0695d27c1e3ceaf75c7b251c65ddb268696f07c16d2767973d85beb443f211e6445e7fe5d46f0dce70d58a4cd9fe70688c035688ea8c6baec65a5fc7e2c93e8",
      d: "5e666c0db0214c3b627a8e48541cc84a8b6fd15f300da4dff5d18aec6c55b881",
      Qx: "1bc487570f040dc94196c9befe8ab2b6de77208b1f38bdaae28f9645c4d2bc3a",
      Qy: "ec81602abd8345e71867c8210313737865b8aa186851e1b48eaca140320f5d8f",
      k: "2e7625a48874d86c9e467f890aaa7cd6ebdf71c0102bfdcfa24565d6af3fdce9",
      R: "2f9e2b4e9f747c657f705bffd124ee178bbc5391c86d056717b140c153570fd9",
      S: "f5413bfd85949da8d83de83ab0d19b2986613e224d1901d76919de23ccd03199"
    },
    {
      msg: "4d55c99ef6bd54621662c3d110c3cb627c03d6311393b264ab97b90a4b15214a5593ba2510a53d63fb34be251facb697c973e11b665cb7920f1684b0031b4dd370cb927ca7168b0bf8ad285e05e9e31e34bc24024739fdc10b78586f29eff94412034e3b606ed850ec2c1900e8e68151fc4aee5adebb066eb6da4eaa5681378e",
      d: "f73f455271c877c4d5334627e37c278f68d143014b0a05aa62f308b2101c5308",
      Qx: "b8188bd68701fc396dab53125d4d28ea33a91daf6d21485f4770f6ea8c565dde",
      Qy: "423f058810f277f8fe076f6db56e9285a1bf2c2a1dae145095edd9c04970bc4a",
      k: "62f8665fd6e26b3fa069e85281777a9b1f0dfd2c0b9f54a086d0c109ff9fd615",
      R: "1cc628533d0004b2b20e7f4baad0b8bb5e0673db159bbccf92491aef61fc9620",
      S: "880e0bbf82a8cf818ed46ba03cf0fc6c898e36fca36cc7fdb1d2db7503634430"
    },
    {
      msg: "f8248ad47d97c18c984f1f5c10950dc1404713c56b6ea397e01e6dd925e903b4fadfe2c9e877169e71ce3c7fe5ce70ee4255d9cdc26f6943bf48687874de64f6cf30a012512e787b88059bbf561162bdcc23a3742c835ac144cc14167b1bd6727e940540a9c99f3cbb41fb1dcb00d76dda04995847c657f4c19d303eb09eb48a",
      d: "b20d705d9bd7c2b8dc60393a5357f632990e599a0975573ac67fd89b49187906",
      Qx: "51f99d2d52d4a6e734484a018b7ca2f895c2929b6754a3a03224d07ae61166ce",
      Qy: "4737da963c6ef7247fb88d19f9b0c667cac7fe12837fdab88c66f10d3c14cad1",
      k: "72b656f6b35b9ccbc712c9f1f3b1a14cbbebaec41c4bca8da18f492a062d6f6f",
      R: "9886ae46c1415c3bc959e82b760ad760aab66885a84e620aa339fdf102465c42",
      S: "2bf3a80bc04faa35ebecc0f4864ac02d349f6f126e0f988501b8d3075409a26c"
    },
    {
      msg: "3b6ee2425940b3d240d35b97b6dcd61ed3423d8e71a0ada35d47b322d17b35ea0472f35edd1d252f87b8b65ef4b716669fc9ac28b00d34a9d66ad118c9d94e7f46d0b4f6c2b2d339fd6bcd351241a387cc82609057048c12c4ec3d85c661975c45b300cb96930d89370a327c98b67defaa89497aa8ef994c77f1130f752f94a4",
      d: "d4234bebfbc821050341a37e1240efe5e33763cbbb2ef76a1c79e24724e5a5e7",
      Qx: "8fb287f0202ad57ae841aea35f29b2e1d53e196d0ddd9aec24813d64c0922fb7",
      Qy: "1f6daff1aa2dd2d6d3741623eecb5e7b612997a1039aab2e5cf2de969cfea573",
      k: "d926fe10f1bfd9855610f4f5a3d666b1a149344057e35537373372ead8b1a778",
      R: "490efd106be11fc365c7467eb89b8d39e15d65175356775deab211163c2504cb",
      S: "644300fc0da4d40fb8c6ead510d14f0bd4e1321a469e9c0a581464c7186b7aa7"
    },
    {
      msg: "c5204b81ec0a4df5b7e9fda3dc245f98082ae7f4efe81998dcaa286bd4507ca840a53d21b01e904f55e38f78c3757d5a5a4a44b1d5d4e480be3afb5b394a5d2840af42b1b4083d40afbfe22d702f370d32dbfd392e128ea4724d66a3701da41ae2f03bb4d91bb946c7969404cb544f71eb7a49eb4c4ec55799bda1eb545143a7",
      d: "b58f5211dff440626bb56d0ad483193d606cf21f36d9830543327292f4d25d8c",
      Qx: "68229b48c2fe19d3db034e4c15077eb7471a66031f28a980821873915298ba76",
      Qy: "303e8ee3742a893f78b810991da697083dd8f11128c47651c27a56740a80c24c",
      k: "e158bf4a2d19a99149d9cdb879294ccb7aaeae03d75ddd616ef8ae51a6dc1071",
      R: "e67a9717ccf96841489d6541f4f6adb12d17b59a6bef847b6183b8fcf16a32eb",
      S: "9ae6ba6d637706849a6a9fc388cf0232d85c26ea0d1fe7437adb48de58364333"
    },
    {
      msg: "72e81fe221fb402148d8b7ab03549f1180bcc03d41ca59d7653801f0ba853add1f6d29edd7f9abc621b2d548f8dbf8979bd16608d2d8fc3260b4ebc0dd42482481d548c7075711b5759649c41f439fad69954956c9326841ea6492956829f9e0dc789f73633b40f6ac77bcae6dfc7930cfe89e526d1684365c5b0be2437fdb01",
      d: "54c066711cdb061eda07e5275f7e95a9962c6764b84f6f1f3ab5a588e0a2afb1",
      Qx: "0a7dbb8bf50cb605eb2268b081f26d6b08e012f952c4b70a5a1e6e7d46af98bb",
      Qy: "f26dd7d799930062480849962ccf5004edcfd307c044f4e8f667c9baa834eeae",
      k: "646fe933e96c3b8f9f507498e907fdd201f08478d0202c752a7c2cfebf4d061a",
      R: "b53ce4da1aa7c0dc77a1896ab716b921499aed78df725b1504aba1597ba0c64b",
      S: "d7c246dc7ad0e67700c373edcfdd1c0a0495fc954549ad579df6ed1438840851"
    },
    {
      msg: "21188c3edd5de088dacc1076b9e1bcecd79de1003c2414c3866173054dc82dde85169baa77993adb20c269f60a5226111828578bcc7c29e6e8d2dae81806152c8ba0c6ada1986a1983ebeec1473a73a04795b6319d48662d40881c1723a706f516fe75300f92408aa1dc6ae4288d2046f23c1aa2e54b7fb6448a0da922bd7f34",
      d: "34fa4682bf6cb5b16783adcd18f0e6879b92185f76d7c920409f904f522db4b1",
      Qx: "105d22d9c626520faca13e7ced382dcbe93498315f00cc0ac39c4821d0d73737",
      Qy: "6c47f3cbbfa97dfcebe16270b8c7d5d3a5900b888c42520d751e8faf3b401ef4",
      k: "a6f463ee72c9492bc792fe98163112837aebd07bab7a84aaed05be64db3086f4",
      R: "542c40a18140a6266d6f0286e24e9a7bad7650e72ef0e2131e629c076d962663",
      S: "4f7f65305e24a6bbb5cff714ba8f5a2cee5bdc89ba8d75dcbf21966ce38eb66f"
    },
    /*
     * This vector comes from Suite B Implementer’s Guide to FIPS 186-3 (ECDSA):
     * http://www.nsa.gov/ia/_files/ecdsa.pdf
     */
    {
      /* The message text: "This is only a test message. It is 48 bytes long" */
      msg: "54686973206973206f6e6c7920612074657374206d6573736167652e204974206973203438206279746573206c6f6e67",
      d:   "70a12c2db16845ed56ff68cfc21a472b3f04d7d6851bf6349f2d7d5b3452b38a",
      Qx:  "8101ece47464a6ead70cf69a6e2bd3d88691a3262d22cba4f7635eaff26680a8",
      Qy:  "d8a12ba61d599235f67d9cb4d58f1783d3ca43e78f0a5abaa624079936c0c3a9",
      k:   "580ec00d856434334cef3f71ecaed4965b12ae37fa47055b1965c7b134ee45d0",
      R:   "7214bc9647160bbd39ff2f80533f5dc6ddd70ddf86bb815661e805d5d4e6f27c",
      S:   "7d1ff961980f961bdaa3233b6209f4013317d3e3f9e1493592dbeaa1af2bc367"
    }
  ],
  "p384sha1" : [
    {
      msg: "abe10ace13e7e1d9186c48f7889d51473d3a0961984bc872df708ecc3ed3b8169d01e3d96fc4f1d5ea00a03692bcc5cffd53787c88b934af404c039d3289b5bac5ae7db1496875b5dc73c309f925c13d1c01abdaafebcdac2cee433939ce8d4a0a5d57bb705f3bf6ec08479511d4b4a3211f61649ad6274314bf0d438a81e060",
      d: "a492ce8fa90084c227e1a32f7974d39e9ff67a7e8705ec3419b35fb607582bebd461e0b1520ac76ec2dd4e9b63ebae71",
      Qx: "e55fee6c49d8d523f5ce7bf9c0425ce4ff650708b7de5cfb095901523979a7f042602db30854735369813b5c3f5ef868",
      Qy: "28f59cc5dc509892a988d38a8e2519de3d0c4fd0fbdb0993e38f18506c17606c5e24249246f1ce94983a5361c5be983e",
      k: "ba25756f1a4a9853bbf60cb2c789569fd551abf3a9cceb889ff71ab5ef7758a3e302166bf2a01a29af18ffbd329cd781",
      R: "6820b8585204648aed63bdff47f6d9acebdea62944774a7d14f0e14aa0b9a5b99545b2daee6b3c74ebf606667a3f39b7",
      S: "491af1d0cccd56ddd520b233775d0bc6b40a6255cc55207d8e9356741f23c96c14714221078dbd5c17f4fdd89b32a907"
    },
    {
      msg: "f6c1063a44a18265cf2861a089e85d7919ad6b4648359477d820d419c10cbfa4c11d874bf4a08b971ebe56287d8e86d8f1ebc6293c78b738c7f048e059a6f28e8919f2f4853a0b28ace36ac5bc8da7f096ecbb795107f5f1da621deca31acfcd5a2109e6a051da338df7480c0258b511786756484d6ad748c7304abe90f7e233",
      d: "f058ab8da69bb97e830d94a0e062b547404a667627a81840fdaafcce1e84473d873e2ace6a8d2a1888948063a3b32056",
      Qx: "762baf5164a5b1b9f7773808ddc1a4fe5ba692b33a9dec84a7b647c265153f0684fc1d4e2c1fde0567feaab5f0436dce",
      Qy: "d3677aeedb149527581f0473521e0d78140cd32a96e1d9e1ca4b64f8cef970212c8e3d9043de251f8b8b337f54e8cfa4",
      k: "1bf4fa2025cd522e630e36dde7805f9df1cb9729105e4e751004d2997017fbd14a2dd36c8b5d24f16704da442770c381",
      R: "70f6087c96d29d9ca44ec14773c85eb23708cdff30dd0858da741d0d7687f0e6b9c04620cc757cf106f8d7ea04504442",
      S: "a07783086ec45c2be737001fa90fe91412731d59364bddde22525fb5bff00718a5ec0fa0ff6f5ad71ada41db7af32395"
    },
    {
      msg: "429ba62978a21129a87d8e50c6c06e26b94b42c74b079942f986c786ea7f294ca415ba9e4822eec1e269408acbfc18b6fb6790c7e4d234bb047a03c9d9736071d55d124ebd943a2bc5a396f96e680131dfb5dd21db63a67d319c8b471cbb093d6211061e0796d7d17817fe186d0d909258d6c68394521666d4eb99506c8fb280",
      d: "3d2a59c2b324339f298eeab2a67fd8977f0ab5ccfedebbe7520216e4d194d0232206cc2ede6f7e6d34a383090f105c47",
      Qx: "74c83ada1218cb5f6b303b1e9ce72973a574216b451543d09920854925dc12f01594d81d405885136d0e68328f7270a2",
      Qy: "34d1ea91b3cf5c34abfece7b778c90f18d62a7b34562e74a340e164b9a7872d3f8cc0703fbcd86093b8ee1c6f6ecc1c3",
      k: "0c8b1775b01b6a98adc2edd136851713bffb41eaaf8da779f18b9d4e46dc25a9ea69788951bcbdb2b3414bffa94c1a8c",
      R: "99664f7a18c378e89499ac5013c9549f66b9536d534e37f9035b6d579e1d1c6308f24330f3c6919b22892c613b296808",
      S: "749554953a6dcc2e75552eaeae5608d4065358e3bf1c54c80b3a2942c61487aea88b651fb06f5ac6173b8428eb9cd4c2"
    },
    {
      msg: "a735612430e7824d2f0c23a4997887fd129ce01a72ec8944c366b2397cd189dbdd978e904ff8b1b00a5f5b0f7adcf7075000b6820959ee93bb3a54db87790b27d5b9abbc1bfbb3c7048f9f5f403b39f5da6777efe7af7d357bbaa371d8554dbb817ced9c70d8ef268fde3d5a9cbe68114a8768e1734eec2a3ff7694374d2c607",
      d: "4f9312adcfad6ffdd0c4cc4f1367e52ebc37dd8f0b11c685f846771b8d45c70ba420e6567387948800d6cc9201bfe60e",
      Qx: "8c08e4f67ea47522582bf2ebb8b06961b10892500f05c5aac66ff5b757518285b460bb152525e671a6dfda2b6e678e14",
      Qy: "7961721a35d8319700ebc3adabb9f686f44d1674bd9f542e8295b2ffe8b48d69e71ddeec38612abcbce296d059d03be9",
      k: "c1fe6ac7761cfe487ff24e4f87889524febf50db850608b4f7655e5b4d9715ca5f17a5deab5b9717548069e96e799df6",
      R: "9128a790c7be3008d0fa79b6cebe2fde800045b5fd99df7e8f964439a82d1cd1d0264bee844b20eb7bf2dc490ce9e94d",
      S: "c9214132dd8fe8f08c5d95e35e49dc912c9fdf9d5b2d359855f5373b659962b2c988fb050b14688b51fcf98094bf4ca1"
    },
    {
      msg: "ac248f141503afd56de5b41612b550dc5b2103904d9ef1e2758a4e7b2cee41b6a51bcb246672548d445204b6e51921b47c3b5fdde1274e5f22ed000a566e591e3b4f86d706e0ec3415a7e6cb8df6cbedca983edfd60db5a7be4adb6143e698d3d15717cc7058b811e4c226d0ac8535f4b7242ad261e66778aaae973fd5c1cb02",
      d: "8713954a6fdc62eb278f8f2bc11c6aa6aa96341f87df303103751e4fdde4b7da554de5e568e8d4ef7c5e2520ebd90156",
      Qx: "a770c1dcc22f8fdab4158d798c3bd95cab9c19cb670e789a18e0fb6b474297e5c45fb2e867c28b8c2f077597881d30b8",
      Qy: "7cc9c857d0079c5a187b2a2cd0932d6fe0ec2d8b161d349dd3122d8425513e39df248af04dd3e05ceabad8dc1cec14a3",
      k: "9c04b46e5443683f8a6a77788e0d7204592cf12a17a1cdb785239e46bb3c3d8c61a99c8e2b71ef6a042025144c073521",
      R: "7803606f6e60ed987fe7bae5f97b2c5ce4befc3e1ecf9ffb053abc61e30fa07bb04056d15fafaf8ce53bf6003e875773",
      S: "fd1d3ecc1b8273d22a5659744494deba9bbddc49530487c2ab983cba82522dc99ae68bda00261f6514233a5936435c62"
    },
    {
      msg: "10d63d0932cd02dcac5c00f0a256a04a06b9022b662d72e1ba2156a6347b29eead66d0b16888981e575cd5771ed5188a20d8105c12c9677cfbeedfd00d97a2da392d70b9ee9702f643716b9e98f990c9fc0c30f6d3cfc860c6d279ec71893bfcc42251d51a29253aaab5d26f5a6b35e07675ed98e096dee8cbd3b724c5655ce3",
      d: "9a7c829838b6212aa543c5acece0ab7d4502838a474e25a0d664c1807c787a1706d365942efa6576c8738ad6753048ef",
      Qx: "173182d5e68e8148ec365ae7a2d8a8983e81488d644cf703375b64e8cfe1110d969b8daea8326f4bb62b2f1c26ecdb6a",
      Qy: "b9c8ce3ad95449c6263b4b76d2b5bc1298c6ce0f86545ea893f95e26fc578624ae9cbe4776eabcb16e07cf49f9da7462",
      k: "a5ef3548af0406758bb6714fb7d576f147059482624cfacff4002afc5b71ff034125d5f9b696ab826219d6c240a81296",
      R: "624d9d3b1ac954828fba1fb180882ecfe041bacde373275e68c5096937aaba2c4891430f22bfec7b23f66820d2f9d10c",
      S: "c3245e068837e2e180c57d77f9bb0cce1e14ab8491797ca042e43662d51fca15b52a40f2ec3de80655fe09c33c675ac6"
    },
    {
      msg: "14abd3c6b5f0f29a7f5b35a18547fdb9de5a6506564c0de4017d4ba2c18f848a2773b7f2270e9306fe092dbf2274e17a195817248d688367280aec2e1222caddc90c63de3b8ce77b3de6f80eb477e64fe459aa5820d8e10abb1f46a2b2679b4c8ff211303dff97951fc9233c9f8805176360aa70906035a1fc87446c5f1a0aa9",
      d: "e6136ec60221b53c019866e0c8afa087893339c4b8ccb587083321b4cdae2bc354325c9eb06464958a49fa2de4bc030a",
      Qx: "30603f54d41740151c4f0177540ff12add6e2ad7be5fce0af9cc39c2527c949b2ee66ae723be1380ea71e94e29799fd1",
      Qy: "2445cbd5e8510fe387a433b50d2c60cc70ad11d1af921f7c65d5a2f1ebded3ddb667a9a8985dbef3d3e08161b398f32e",
      k: "d6ed0b3ab1b70984abc67fea5dba4f448fcae34d3b77a1f5301b17d1dfd4e191ab70aeb88d195e2b07df0549287a8c4f",
      R: "350640057ea4c2a02ded8e053e4d5566acf9eb3ee20e76457b1e423109922802b957fea42baeaad9aaa0b101fa67cde1",
      S: "83ce730d9f606eacbd8f1dcae3eb6ce68f559100586577ff11481a706aa632a7abfb1051be086d78cbee27a0b7ad66d0"
    },
    {
      msg: "4920581f4ee31e2d1a9c303ebd7a1712bda879fdeb1daf99dfa28a042ac9d6370bad567ca392d2bc3ed6a2e2002520cbfb10d309e5d4f65ee9d34c836cedc6b67448ad0902ba4e9bb082362a7160230cccb53ee0bfe884e8e2eea81fb1e7dc4aa01f0191c21745aa6431aeabea4987abb68aa53be9a4fd8df2e97013af0d17dd",
      d: "8f1fc47321b1708a0f3f320e3b8e6bb71b57eb334c2cc20553fe2d1cf00ed00c40ee8dbc4704862bc68cb39fcd8dc03e",
      Qx: "c03696284c3c843d28f54591dc813b11da2bb8a83a8ab20e0b54a1b0435d6cefe99fdb5812e87a3bdf8bb600aadc5f8d",
      Qy: "5e32ab64b65c3bafd77fecb64eda186a871684fdcd1c97860d21303e63bc453b3abac338e1f3bcf12a3fa6fe981a2e31",
      k: "32ca5f506bb5f7c95eae80fe849388f76bbd2b855c6e1bb766f9a7d5f4cf6337112f9523039f962e5dc40529fcc331bd",
      R: "a162bb54548941e63cd87753ce77d917cc9f64a6040bbd6c48fae587b2829037bdec9e3a7e09d93ffa5d797be201bcce",
      S: "3798c49f1d2c9507aeaedab09ef22d8bd13353c87fe4685fdc531c04f93fcb95388f1ce1fba9f5090c03b0f3bd9a57bf"
    },
    {
      msg: "5e2525da0c76ad1c7f05b728cf52ef07c6d346ce3382e72bdbd7312ea035f9e2a4920ace8a3524f8c695f9e1cdf35315dfbfe804d79d0ed44b2aff85276f34603f2feb6dfec51b94a5e0ba97dd8294baca948249319e0d5f656d371a67cc32a7fdca78b9c19b19b88dfbb49a552cfcf80fa2724a2d7daa76fa79aec7d82413e3",
      d: "88f54804b66345889537229e0a3ebb01901745bb0c2e58259795ef805bfd449e3e28c88e63f80412855dddf2bfbf16c4",
      Qx: "2dbba355935388d99a59bf1ca24e8f915186a5012325cbaf8b44a77e60986bbd13ade4f5af8d5baeb7f927697d28d35f",
      Qy: "50d67264b86fcef65553455403936d47acdc3b0f0104e4259d62fb838584086f76ab08a98942b9179e4f30b2561fb2b4",
      k: "f426c920e96667343c6d4d6b79e5e1ab97ee7da40d526d3a9f0a992de01795a73c3150d940e0c41311cc120898b8895b",
      R: "948e376bd2f3ef488ef75fd39fd42140dab1a838be08b35f44b898f23e6959ac2bbab05840a42ea70443555677712028",
      S: "a815053ce1a0a65686056331eb952a6098438078a081daa749071fa4d9206692f1f7fe0930fc5aa32ed5034134fe6885"
    },
    {
      msg: "92ef3594e6d80d33276d81121c1a9f31361fe5336642803d44145066728ea29afa32d8fcd5ca995c52e652bbe9ba77cccd377c34a440348d13e27f44e473e50b747a36c5bef085c3e3a56f62d00bf9b2848864a1c8e259d6262a90ab4d85c33b3e382a5ef2bff1ccbe68160e77dc108e558e3283fcced1afd6decc88d8589e44",
      d: "a95cbc7a261e932417b2cc01a0934c1633a5728e876394d27772febbd57e2e6fe3620df15a61813ec00fe0d41b760131",
      Qx: "37873d4ea00a594976d5acf65db8634dd2399b4fb4fabf4a1e3b41fc14d3229a70c41fa164c555d1e617aeeabdf742ee",
      Qy: "7b2d2c9ea694c4ea71ad7ca473be982f2ca25d2ca3f1ac37c23003c665cb9c726dedaa9b913e023b8df52ad3f80523f1",
      k: "7a159b8a33e4319b99ebd523f5a993546d3f27f4a9749cd370dc44fbe49cd323f9ff03b8d5bf548f0ad6acb87207e534",
      R: "9e3db7869dd52ea7eca61eb45831df81763974d8df9bf3a077fea35f9a098a158c91fbd6ea7e6db0d26039a21dedcb01",
      S: "f05e65320b48f1dc92c1eea928aca3aacc768e9570f91b5a60d367c50d178609f685ec8c1584afebd0264a9b770a0786"
    },
    {
      msg: "3f5807da9c649aaac6288006a680fa06a5ecbf6fcd97522753139f41ce4aaf56a02100d5adce1926f49901e45c15408c4c7d8c8f6580d5d004d51446176528252999b4ca5d2f9b42b3f9e770c41d88b7a11c3d0665d7b6621329f28c0b5da0864b6dd40662413071909257e763490f7f23c9a39342af0862b89e03527d317567",
      d: "4a314ec56d0026fc2fcd33c3d098e1b96084b27f3e63bd7defeeebf5f6f6aa751f390dc6dc96b67d62de15a7b06045fa",
      Qx: "977eac715a79a5f2cc277d2d70c7d6b3d8e94b567e2ca383633a1ad749f6ad7e253918caeeeeafc2de3e22fab9db6393",
      Qy: "3a05a8312cbbc5f1aa69aaff8edfc99e12df7964e9058d314a176d1b76ce8207408c6bf0b8904e65f59c7b7058e5ad29",
      k: "79e88b71e5c9c075ed40c207d45a6e16b98fd29208bd950ab823b08fb763e79a586e9a4b03e857532e02f1d71e5ad61a",
      R: "9cc23717d433f808ee8bdc7c7118866c6db672e07c707042c65dce3d77aa44c73ea7d658602db71598f9eeea6a1b55f3",
      S: "6392f35e844c018610be532fe442471b3d7931a9595cddca3c25c5661b1a2d3cc45d90cc1861e6707fc60b820106ec54"
    },
    {
      msg: "7bd895d9f6601838b502b7c1d66f3826915d5e9cb94cd6ba3191432bc0d9259173833a4ed531c01023f520c3bbb92d346fbd2e43e5145f4465db3215c7f56328ef88a28c4f8e8dd803dd552d3fdb703e132a266a391a69020157a2a80331e1219a1712ce278bc80f51f700480fe200f18b33950e0ff7daf5d87c5f87b359914f",
      d: "d01840f4bb77ffef94723457b4f0e29bc2c8454fe85baa97753790f7378a5bf8df6826ac73b86a4630be5175e13e8bee",
      Qx: "b3cb40021bfcb4b09e2eccac438fc9b1f28f6a4d767c5c4a45671d62b8f44ecd3d355634ae225c7d9f1bbf35bd88b3d8",
      Qy: "0611c73f1bffb1cbde6b292b10875054a37ef8ec0a90da121b6b954fb329a9d6779c0e225a01d640f3b140b9cb253c72",
      k: "5647129036d20d84a13d70f2ecb3abe399d1534c629a2e572ba7391ac3a28e6fc1662ca9ce80ec262d7c0a39de7b994c",
      R: "7a253ca0766f90e3b2c1c40e9905787d1144fa1aa528a8a01cbf1eaed5724d225a7c066c95c19f712067243e66080b7b",
      S: "dd3db6f19760b65d3a34dfe19b62208964f523485cae11e8e01f8d3dc7abbf3ab2b8c150122d8b6dd56d6d9b40add3f4"
    },
    {
      msg: "29dd164a7e1dcd2174eb96c0e88c659a1453b6470d77f70d72c3b122780755715a4547ff103c709b4b3bad59484c680635f5b8b67af74156a32d3d5a66509284db68e7fb3b589254e233563bf42fe680878bd8ad1ba3e6e7fe81f0d16e57ba71985cc80c0d6c0695ec779fde8787cc2a3753e978b82fd291faca33d15815fd6d",
      d: "81832668cd5ebb74d8daa33f7414c1d025dd7344a73974fa8d3d58abee83d7418baf17a3e42d43427125d78799c99b52",
      Qx: "d6db14db42e54afbb6b9b52feef267f91d26e23175f87035f3ee5fd48b9bfd6886aa7ef8bb324cd36f348d7c95755006",
      Qy: "2779be1a39113228576250b2a77f9de53cab65645af15ba35e8271369d6fb02ff2bea6ab7d224d8229581b7c58b70448",
      k: "5e5f44e0c9949153ffb4838f32124f458eac07feb916a8480019d550ea25aa49dbd2319f413994dbfd72e5d739863d13",
      R: "0d0249a735fb4566218e56fc436f759996eac374b99f8689d79eb1d13e03a09a87008a7a183e53ed6040d7f80e868bff",
      S: "ab3b29bb70fad6f713dd40be954a0be552475b665010ceddbe883267e90627cf0c51bc1604a60dbf6ed7a053cd314b05"
    },
    {
      msg: "e54221f012f050b34d0feecf3bb427906840a4656374724ad3d41d876275b0d52b98645b190b5985fcd21a39cc662aa6033d4383e4dc48b907c499ab99cbacf3bafb078ccf867707d765e0fbe914c3dc404119639bebb80637b41318ab2c85aa7b70a749903c405b377abeab8e84d2a01961a9c2f3102e6f3b5716b63f89737f",
      d: "2b3bd4814050e3c2f72aed6d05a42a32734bfea28efc8f8b2b5861eee3e457593c315d3fc5f68bc612645d895a2f0270",
      Qx: "087e54b1552ca0ae80731e0a222c27daa8c8bfec958c6f2f9dd87ac3bfa5ad9e0c3bd0233bd99e13c128073299931547",
      Qy: "f76b48d48391e70401e809a395c006c60f6e9febe4d03fa071d8d3b778166e6b047165401cf03c387e797c95965dd741",
      k: "038afebb3fc960c01a494deae196075ae6cfe0671df54248b77e809073cbce376c049b4c472213a0433b292529edeb56",
      R: "8c408a1e940350932da6433227c1384c181e557ad93bd5995d369f25fa65d1cb708d643a21da370a202bf171298382d0",
      S: "d2607418569e36c7839d562463c5488b207ad9685d2449651f6d35b42383d2118568d55eee85009a72a4d4a9b9a1ccb3"
    },
    {
      msg: "7ff90295dc87aa889a0eb6a2dfb864ced3fc12b42670eaa3bd04aa886341fda408d559b5bceca805fdf045399e0f1892ea4edfae35714f1df09f9c473c7c66220403da0697e321bfc0c36da141988a45619fb466621f102431ec74765146468ea53e5a792121495345a23ebecc1e673a3164ad7f7b25f053f0dc50e4e5cb95d1",
      d: "8918f0a85ec63cacbf866ecdd61fe905582f677be22bf8f9a830df7c3803df864d39efac6aef10b160b8b9a459aed096",
      Qx: "0e4afaf083220ea3de006bed7ebd2ce2d7a7d3723779718a2a591859506c1f9c8e370d12b8e433eb1ae1650bf000fa56",
      Qy: "a50c5ca35317455edd87bddf470d9af037868a54af8ae756592cacba2d1ade447497e2263c9dacb7b7165c7bd0a3c31d",
      k: "c9c84818894e0c338c0fce743e189e8bef4c31e43091b7afb580d7821e6f3c4ca6b3852ae7c3d7f682c2fcf27ebcf12f",
      R: "d7a1d00584ae855f823e77c77f9ac300eeb2af078e42ab0a0a43cea510d8a6a6a1ac3a6ba13c4543efdb4b046028584a",
      S: "c38750449a3603f41667a966999700fc6afcf212e677a18b91be974819cbd33c5e88984f1d1db600351d5a78863bda2e"
    }
  ],
  "p384sha256" : [
    {
      msg: "663b12ebf44b7ed3872b385477381f4b11adeb0aec9e0e2478776313d536376dc8fd5f3c715bb6ddf32c01ee1d6f8b731785732c0d8441df636d8145577e7b3138e43c32a61bc1242e0e73d62d624cdc924856076bdbbf1ec04ad4420732ef0c53d42479a08235fcfc4db4d869c4eb2828c73928cdc3e3758362d1b770809997",
      d: "c602bc74a34592c311a6569661e0832c84f7207274676cc42a89f058162630184b52f0d99b855a7783c987476d7f9e6b",
      Qx: "0400193b21f07cd059826e9453d3e96dd145041c97d49ff6b7047f86bb0b0439e909274cb9c282bfab88674c0765bc75",
      Qy: "f70d89c52acbc70468d2c5ae75c76d7f69b76af62dcf95e99eba5dd11adf8f42ec9a425b0c5ec98e2f234a926b82a147",
      k: "c10b5c25c4683d0b7827d0d88697cdc0932496b5299b798c0dd1e7af6cc757ccb30fcd3d36ead4a804877e24f3a32443",
      R: "b11db00cdaf53286d4483f38cd02785948477ed7ebc2ad609054551da0ab0359978c61851788aa2ec3267946d440e878",
      S: "16007873c5b0604ce68112a8fee973e8e2b6e3319c683a762ff5065a076512d7c98b27e74b7887671048ac027df8cbf2"
    },
    {
      msg: "784d7f4686c01bea32cb6cab8c089fb25c341080d9832e04feac6ea63a341079cbd562a75365c63cf7e63e7e1dddc9e99db75ccee59c5295340c2bba36f457690a8f05c62ab001e3d6b333780117d1456a9c8b27d6c2504db9c1428dad8ba797a4419914fcc636f0f14ede3fba49b023b12a77a2176b0b8ff55a895dcaf8dbce",
      d: "0287f62a5aa8432ff5e95618ec8f9ccaa870dde99c30b51b7673378efe4ccac598f4bbebbfd8993f9abb747b6ad638b9",
      Qx: "b36418a3014074ec9bbcc6a4b2367a4fb464cca7ec0a324cb68670d5c5e03e7a7eb07da117c5ea50b665ab62bd02a491",
      Qy: "4ea299c30e7d76e2c5905babada2d3bb4ee5eb35a5a23605cdb0d5133471a53eb9e6758e49105a4eaf29d2267ba84ef2",
      k: "935eeab3edeb281fbd4eead0d9c0babd4b10ff18a31663ee9de3bfa9ae8f9d266441158ea31c889ded9b3c592da77fd7",
      R: "738f9cb28f3b991335ef17b62559255faf75cad370a222464a492e27bb173c7f16b22100ada6b695875c7e4b1a28f158",
      S: "bc998c30e1491cd5d60dc7d1c38333165efe036b2a78db9b8f0e85ee68619cfba654e11ae5ca5ee5a87099c27cf22442"
    },
    {
      msg: "45e47fccc5bd6801f237cdbeac8f66ebc75f8b71a6da556d2e002352bd85bf269b6bc7c928d7bb1b0422601e4dd80b29d5906f8fcac212fe0eaaf52eda552303259cbcbe532e60abd3d38d786a45e39a2875bce675800a3eaeb9e42983d9fd9031180abd9adccc9ba30c6c198b4202c4dd70f241e969a3c412724b9b595bc28a",
      d: "d44d3108873977036c9b97e03f914cba2f5775b68c425d550995574081191da764acc50196f6d2508082a150af5cd41f",
      Qx: "c703835d723c85c643260379d8445b0c816fe9534351921e14a8e147fe140ec7b0c4d704f8dc66a232b2333b28f03dee",
      Qy: "c5d0bb054053fd86c26f147c4966757aa04b00513a02d427b8d06c16055c607955efdc518d338abfe7927c195dc28588",
      k: "c80f63e080650c8a21e4f63a62ec909adfb7d877f365d11ee1cb260baf112eb4730c161c1d99dba98fc0d5bbd00dc97d",
      R: "81de2810cde421997013513951a3d537c51a013110d6dbb29251410bcb5ba001a9686b8490f1e581e282fd2ed0974b22",
      S: "9cab0bbaffe91c7677ec3dd1f17060211a3cc0be574cbca064aa8c4b66ba6e64f3d80e83da895042ca32d311c388d950"
    },
    {
      msg: "c33ff63b4e6891e00b2349b3f2907c417ca355560544a91e24a7a0ee260d6850aeded29fc0176b6039ca6187e8333391047cceaf14b1077df8f147dad84d36b2dac5666dc2f69dc9b58b88cc73956efdb3b47f91831d5875051c76b0c4e9fc087012a1f03eeee85d6745b46aa50bd9cb0110c2c94508765cec162ee1aa841d73",
      d: "d5b72cbb6ec68aca46b9c27ad992afd8ffa02cb3067b234fcfa6e272e3b31be760695ff7df988b57663057ab19dd65e3",
      Qx: "135a6542612f1468d8a4d01ff1914e532b1dd64d3627db9d403dc325651d3f82b0f6f0fd1dbdeca2be967c4fb3793b5f",
      Qy: "cbbd40f6d3a38d0dfb64582ff4789d7b268241bc0c36de2884bccfaeeff3b7b2b46a30bb35719804e0d11124b4e7f480",
      k: "9da6de7c87c101b68db64fea40d97f8ad974ceb88224c6796c690cbf61b8bd8eede8470b3caf6e6106b66cf3f0eebd55",
      R: "17840911ecdf6ae0428b2634f442163c2c11b8dbf0cc7a5596fbe4d33e3e52f9d99e99ad169867b1f39e89c9180cedc2",
      S: "dd7ed67e480866d0474379ea4afff72870746f4feef2153be42f13bf472b1613d7faa5c0abb7f7464070f94d7cf3f234"
    },
    {
      msg: "f562f2b9d84b0e96a52532c3b43c39c8018c738bd8dc3797a7de7353971b2729d522d6961b1f2e4df3f6a4bd3653e6d72b74fc0dba92ab939c4b542e994e5db6dd8ed4f56f651e699052e791237ae1f552f990ad156226ae8f7bf17fcbfa564f749604f97e9df0879d50985747d981422a23040fe52f5ec74caf1d4aaad8a710",
      d: "218ee54a71ef2ccf012aca231fee28a2c665fc395ff5cd20bde9b8df598c282664abf9159c5b3923132983f945056d93",
      Qx: "01989ff07a7a452d8084937448be946bfedac4049cea34b3db6f7c91d07d69e926cce0af3d6e88855a28120cf3dba8df",
      Qy: "eb064e029d7539d4b301aabafe8de8870162deffe6383bc63cc005add6ee1d5ced4a5761219c60cd58ad5b2a7c74aaa9",
      k: "c5d39b436d851d94691f5f4aa9ef447f7989d984f279ae8b091aef5449ac062bcc0567740f914624ad5b99fc32f9af0b",
      R: "07d5b1b12877e8cb5e0aa5e71eeeb17bf0aa203064c7e98b3a1798a74dc9717252dc47c7f06aaf1d5fe15b868323bbb9",
      S: "69428cf101a7af5d08161a9fd7af212e02e33b6062aebdce4c96bf3a0684b5394cb902ca7c2dec6e2f01f40c4576009d"
    },
    {
      msg: "ace953ae851f571d71779aa120915f27450b236da23e9106f8d0756abdd25861937941228d225d5fb1aa1b1ebf759b1e326aeb3b6cd0cd87edd2ab9f6a7ad67b63d2c501d6a550edb2e7c9d216cc8af78dd33546af64d00abed4d0d2cfc5c9a7b5a055dbe8f7547902d185cf46937314832bc5c602419a82ab83dbd9d3bd5aff",
      d: "e6ab171f6937c000e144950801ad91023ae8e8476856c2592d9f7d5bb7180fd729211803d39a412ead6c0be761cfa5d1",
      Qx: "38bc42b8c9d8866d09b214398d584b1b24a488dfacc3420d1e9506aa825b19fdf1ba74e7b8f547f47b571467fe8c4d1f",
      Qy: "5179d62668d3f6a7ab5c8e3761a685e12008fb87d0529a97645f65cfb5364376c1b6682e0ffcddd0bcd995c41d013ad3",
      k: "05e9718aea9669c9e434f73866da5f252dec6d24c47a1c4ee3233450b6ec626de9746ebe095b285558dfc89fc1b622fe",
      R: "df9bab9dd1f22ec6f27116f38831cb2089aa78aa8c073024a0faddd9a48e810a5e8e2cadd80fbf8dbd6088c71fe30b5b",
      S: "1e0e8718567d12d18558c57f9e87a755c309e4ffb497335a3adfc8d7475ce8fd882d5dc33a8f5a16274b7ad74bb7862a"
    },
    {
      msg: "9635ab832240be95301bedb94c5aec169eedc198cbbdfedcf41e9b586143d829b4597a6b2a81902828332825fd84a785f187a3894e21bd99d22c4f94dcf34453fc052f15ec64d1447c932cb38fcdd30b7be851963409c11881438cbaad7e96f9efbde317f2235d66af804477a5dfe9f0c51448383830050ecf228889f83631e1",
      d: "14acd516c7198798fd42ab0684d18df1cd1c99e304312752b3035bed6535a8975dff8acfc2ba1675787c817b5bff6960",
      Qx: "29909d143cf7ee9c74b11d52f1a8f3ebd4a720c135612ca5618d3f432f03a95602ee75a2057e1d7aab51d0648ac0b334",
      Qy: "404b6c5adffbadfa1b0380ae89fed96ec1ca16cc28661e623d0f1c8b130fbaa96dd7257eae2bf03c2d3dcbc3dbc82c58",
      k: "7f623c103eaa9099a0462e55f80519c565adaeffcb57a29993f3a8a92e63a560be8f0fb9d23dc80bff1064bb41abad79",
      R: "932ab291950c16b2b19a8036cd2e905714c6229cb190a73b3ea49c48dd8e76063a453c7c3267a57597d2973678216296",
      S: "d17d4c5ddbb9c27beebf526f113b416c8abfad53d11c4224813c7f351ba41a77dd4e77d6e4a65bef2c9f62cc37a469a5"
    },
    {
      msg: "d98b9a7d4fe9d0fd95de5056af164a8b7882cd34ab5bde83a2abb32dc361eb56a479a3a6119db3b91dcad26a42d2206749567f0d97c34a981a91fc734921821a429f6a53401743a5c406ba9d560f956203abc9d1f32f1a13e7d7b290f75c95fdbf857ea597021461c06a3aacfa554ede3d69e4ff03bbbee5b7463ec77de2b3b2",
      d: "2e780550984f3a00cb1e412429b33493c6eb6cd86d12f9d80588c247dcf567bd04296d2d4b24b889d9c54954b7f38f57",
      Qx: "37dac42ef04663238443ef33e8addee2e78c40d50a1751913a7f5c37d1f23a26c7f86e16055c788b8ca9554f06b2f2ef",
      Qy: "bbed1549652904e3d00c39b01cc0460dbaf3185e6190c2705677a9701de1fe56dff4f4d8418ee15059ff8fc36800982d",
      k: "b788ca82811b0d4e4841765c71eafaa1e575378beedcd3860d8b92db3d070ac5aef7c425067860fbee6c50cf0c642bbb",
      R: "7292b3851870daeb2555a8a2fb198ead78739fcfb75327e5c32a82c6b77d58983e5ad548ccb75dcf9411039c9576d9b9",
      S: "a378c61802d9f1dd062b6e18f16416a954018f77df4df95ad1b983570377d5cfce4cc7861759e802c52f81abc4f49aac"
    },
    {
      msg: "1b4c754ac1c28dc415a71eac816bde68de7e8db66409af835838c5bb2c605111108a3bf13606ed5d8ade5ed72e50503e0de664416393d178ea4eec834d8d6f15039847b410080fd5529b426e5aadd8451c20ebd92d787921f33e147bcbeb327b104d4aab1157fc1df33e4d768404b5ccb7110055c2508c600f429fd0c21b5784",
      d: "a24d0fe90808aecc5d90626d7e6da7c9be5dfd4e1233c7f0f71f1b7c1c6fd318fafe18559c94718f044cf02ed5107cb1",
      Qx: "ec8ae1fb9bb88589d27d6f27d790392853396f37bc0c381631d85800fc668eea0886bf1c6cff801147df19778d5b1604",
      Qy: "1e1a8336c1e2506f8ee388b55cc648ae73b9295ea78467979d2affb364536fad28120f51ec62a67cbb6ce7784780389f",
      k: "755d025509b73cf1ea8817beb772ad150b4c17a52378be187daffe3db0158921e5e552d1ca3c85df28519939f3cb794d",
      R: "23ff2ffa62bbd427d49995d9c9950116e0d5a06ef076a4553448bc109e6482c5e87d4c833bc88de0bc722bc98cae2e61",
      S: "9aea13d487c3ea6917e16374caafcf0321c12a80d28902dd8cd81909bb04b8c439e2491e504756742d0d0bfb15a9c34c"
    },
    {
      msg: "3cd8c053741dd9f974c6c5dbf8a1e5728e9b5eafb1cbcfc3452f5fbbda32a8c7564dee157e8d902c52514361da6d972934a56b3276e2a9379e328e24282e0db697c5bc29090fc489ec46b7b188325dd4e96494c250de0f4a89fe2ccf919eaefcfb50c288113e6df92714feb7f46e0822478c796d0f4ff3447a32997e892693ce",
      d: "1c172e25732555afee7ded67a496f3f11babc0875898619f4519c29321e201e8ba1149f2c20b48e5efba235d58fea7c3",
      Qx: "13e9e2c8bbcfe26e8f5f43c86268c5980ee693236a6b8777f3a7323718baa21005b482d08aafc6fa6e3667d91353544c",
      Qy: "9ba181b3ee505be030f87ecd249b00670a791489b42af04976013483ff95b630c91c01e95757e906129f2f9b4ce719a8",
      k: "08aec9a9e58bdc028805eb5dc86073d05fff1f5fb3fd17f510fc08f9272d84ba7aa66b6f77d84fe6360bd538192bf01a",
      R: "2b4337c3dfbc886ffad7858ae2480cb62227e12205a70361c42f1a5ca9e658ee30fc3cf4030d85bd065edad83b99821f",
      S: "2550cef8574bf17fb3d6b0c9d04ab266962bac3621bac233ff2e4989712d2a4a07171c0aebd3040cd6a32c3bd3efb8b5"
    },
    {
      msg: "ed955dda6d9650124804d3deb6aeef900e520faf98b1ef6f14efcada7ca2433f09329b70897305e59c89024d76e466b28fe02cb2a9b12e2478c66470259d7c282137a19e5a04ffadea55245c0f34a681593fedc42931d8b3321b3d82e9cc102cd00540ad311ec7bd8c9d06db21bea4ca3dc74d98931ae0d40494aefc2345132c",
      d: "5b96555dbd602e71d4d5d3aee19fd1ea084ee23d4f55c10937056762bc2015cbded2e898a487f5482ab7e1e971245907",
      Qx: "6e14c17bb831b0112d7f3543c5fd17c78379a516c9e0539b03b8b4bfdead2820343fc84b0382807573ded6c4d97b7003",
      Qy: "7f60021d2de77546db666721c9aec84c3e2ba8de0ba77443600dc77e6839bbf9316271adb22d4cb47d08f745ecb1dafd",
      k: "7ad6f4ffd2b429ba10c6f112f800cacf1ad508cf8eba880893bb9659c1ddaaec57dcdc093a114500460d457bdde324f2",
      R: "faea950ca513806bc59028c638d6302ffc86978c3ff1f06db015dd7c4777050186cb8dd871f5e926e1416539c1939c2f",
      S: "2c592240eabb8a1f9878e1b5c9d5d3ced7b3a7ae571f5a86494ed2ca567a36eb72e7bea8934bded29594bccf67ca84bd"
    },
    {
      msg: "ce395b001da2a58e49691605d44af4206306f62f561bf2394060d2a5591a350277166bed043819035f1e60b5b3fb5ae113ddd0473f8ef6b2b050c472c2a264e1d8b3ca82a4f158c40f2d78d9ce5e5ea6de243f2e1f13f47f6c6f403b270912c81c636be35b396ca58468b3fb60aa83911d61441a0528d973bc31f965d4059080",
      d: "8df9c3c710a25192f3dea970910bb3784e3509874cccf4334823eb9f7a8d05b067f2d812d61e878e24b093089a0b8245",
      Qx: "92c9e32b20cbe6d4ed0727c6c942cf804a72031d6dfd69078b5e78ebce2d192268f1f5e2abce5aaf1f8d6a35f136837f",
      Qy: "d5167905fa7689e03b9fb1487c566f62b36f2bc1c4a2bfb6a836113b5c8d46f7c1ca51b628b14397fbc06ec9a07f4849",
      k: "258dd05919735cd48627c9fe9fac5c252604aa7c2ae0460d7c1149cd96b7bd2ba195ad393bf392a2499f06aead5ba050",
      R: "413793bcce52eda0f5b675a8d687cce86d5c9e1659b38a89e96246b5e05f8b0934d17dbba3b2ea44c838aa5fd87125d1",
      S: "ce7309fc2d6e3438818a1a29a997410b025b0403de20795b97c86c46034a6b02afeed279aeb06522d4de941bfdf50469"
    },
    {
      msg: "ffefe316455ae4ffdb890bb804bf7d31424ea060ecacff419d0f7134ff76ad434063c0ec0f8bb7059584d3a03f3625bb9e9f66ace1a47ac4b8f3e76fc7c420c55edb1427d1fa15b387ad73d02b0595c4e74321be8822752230a0dcfb85d60bfa186da7623a8ec3eb1633f0a294b23ae87216b14ccee9ef56418dcfab9427371e",
      d: "6002cb01ad2ce6e7101665d47729c863b6435c3875de57a93f99da834f73e3e6e2b3880e06de3e6bd1d51ea1807ab0d7",
      Qx: "e4216e1a20af8e8e3e74653ac016545001066e53e64af679ad1c85841bb475aed3e00ead052ae9955f48d675ff4ace56",
      Qy: "8804c17641be21d4c6386902c9c5c888af25d97ca383703ea4a85cf93bbab360c0bbd2993374da499a303778650270b9",
      k: "6b9507fd2844df0949f8b67b6fde986e50173713ac03df2edf65cb339859321cd3a2b9aab8356f95dec62460ab19c822",
      R: "018891f6381ed358b422f79a299cf0789cee783ba388af4d82cbbe17f3709751b7fd9400e9702820c28b9afc62fdf489",
      S: "aef73bd590802b2fd2a65c4f7fec89f9b24ecc199a69254785925f334cd1977c5e1f858bd9830d7d7d243ea707b1af0b"
    },
    {
      msg: "304bccb718b3a9e12669913490cc5bcc1979287b56c628fad706c354241e88d10e81445a2853e3fc32ece094ba1abc3fdcab61da27f9a0fca739371049fed462ee6b08fa31cde12720f8144a6f00ce9b1a7a6eadd231f126717074b4efb5c72ce673ca5859000a436f67a338d698759f12c461247c45a361fb6cb661fdbe6714",
      d: "d8559c3543afc6f7b3dc037a687bad2630283757ba7862fd23ed14e2151a4cf5fed3d249268f780e0b96b6b46274a2d5",
      Qx: "5f94223918f2ec9f0a08342cb99e724881c92453957c59672860f69daac01b660331a0f5845e50f1f27766b219c89e7e",
      Qy: "d76d83396130d10d1168d76c7fc83742ffffbe66d9f4da4ca3f95f5ad6dac8cc7bb65d16d317d37aa99fdbf30ec7439c",
      k: "4ad5a92b5b8e170b71c8a7ed419dc624c7680004562b8d16a37b6e639f581ce81d5f0d98cce44d54c4e7136229148340",
      R: "f7baa6a5488ab462ea59aa31a36402b15880c68110b6069f51ede0c3b52a7b1e5bf926fdbe95768931b7d5f87058835c",
      S: "28b1c4ef448a432f7c91b98b0c6471691e888211b6af907369a8930859b8cdb2e94f466a44f4e52f46df9b0d65e35de6"
    },
    {
      msg: "64f9f05c2805acf59c047b5f5d2e20c39277b6d6380f70f87b72327a76170b872bfe4b25c451602acfb6a631bb885e2655aee8abe44f69c90fb21ffde03cef2a452c468c6369867dfd8aa26ac24e16aa53b292375a8d8fbf988e302bf00088e4c061aa12c421d8fe3cbd7273b0e8993701df1c59431f436a08b8e15bd123d133",
      d: "b9208cbfd186ddfa3efd5b71342ae1efb01a13ebc4c2a992a2cbee7254b7846a4252ece1104b89d13d835911f8511224",
      Qx: "166e6d96cb60d916fd19888a2dd945a3306ff0d7b0a5e30729f47d3dac3de2be3fd5cd7437e9a80d6c48cf960d2d36f8",
      Qy: "e6b2b70f131092ae210f29cc6bad701318bddb31bddf921695855c6208941100d0cee5d10799f8b835afe3ea510e8229",
      k: "da706ab5f61531f2378b3c0a2b342108cd119eadaa88b859df64923bccfb0ec2393fd312826f65c15a6587d1d460015b",
      R: "d9124c42858080c62400e4d4d8136304e03d910cbe9b9b3487f4d27c7e0540a314d34bef8c850045c8746ca631c11c42",
      S: "bbf6424a3b70166fa799f49e918439d515327039258ef9bd88435a59c9c19659f8ec3c8660720b0c08354ff60e0f5a76"
    }
  ]
};
