## Hyperledger Fabric-CA Client for Node.js

[![NPM](https://nodei.co/npm/fabric-ca-client.svg?downloads=true&downloadRank=true&stars=true)](https://nodei.co/npm/fabric-fabric-ca-client/)

SDK for writing node.js applications to interact with [Hyperledger Fabric CA](http://hyperledger-fabric-ca.readthedocs.io/en/latest/users-guide.html).

This package encapsulates the APIs to interact with the Fabric CA to manage user certificates lifecycle such as register, enroll, renew and revoke.

Additional packages are also provided:
1. `fabric-network`, to provide APIs to connect to a Fabric network, submit transactions and perform queries against the ledger.
2. `fabric-common`, encapsulates the common code used by all fabric-sdk-node packages supporting fine grain interactions with the Fabric network to send transaction invocations
3. `fabric-protos`, encapsulates the Protocol Buffer files and generated JavaScript classes for Hyperledger Fabric

For application developer documentations, please visit [hyperledger.github.io/fabric-sdk-node/](https://hyperledger.github.io/fabric-sdk-node/)

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.
s
