'use strict';

//Bring the important classes
const fs = require('fs');
const yaml = require('js-yaml');
const {Wallets, Gateway} = require('fabric-network');
const Car = require('../contract/lib/car.js');

async function main(){
    const wallet = await Wallets.newFileSystemWallet('../identity/user/Bob/wallet');

    const gateway = new Gateway();

    try{
        const userName = 'Bob';

        let connectionProfile = yaml.safeLoad(fs.readFileSync('../gateway/connection-org2.yaml', 'utf8'));

        let connectionOptions = {
            identity: userName,
            wallet: wallet,
            discovery: {enabled: true, asLocalhost: true}
        };

        //Connect to the gateway using the specified parameters
        console.log('Connect to the fabric gateway');
        await gateway.connect(connectionProfile, connectionOptions);

        //Getting the network
        console.log('Using network channel : mychannel');
        const network = await gateway.getNetwork('mychannel');

        //Getting the smart contract
        console.log('Use org.carmarket.car smart contract');
        const contract = await network.getContract('carcontract', 'org.carmarket.car');

        //Submit transaction for car sale
        console.log('Submit car info transaction');
        const sellResponse = await contract.submitTransaction('info', 'Alice', '00001');

        console.log('Process sell transaction response ' + sellResponse);
        let car = Car.fromBuffer(sellResponse);
        
        console.log('Car info displayed');
        console.log('Transaction complete');
    } catch(error){
        console.log(`Error processing transaction. ${error}`);
        console.log(error.stack);
    } finally{
        //Disconnection from gateway
        console.log('Disconnecting from Fabric Gateway');
        gateway.disconnect();
    }
}
main().then(() => {

    console.log('Sell program complete.');

}).catch((e) => {

    console.log('Sell program exception.');
    console.log(e);
    console.log(e.stack);
    process.exit(-1);

});