'use strict'

const fs = require('fs');
const yaml = require('js-yaml');
const {Wallets, Gateway} = require('fabric-network');
const Car = require('../contract/lib/car.js');

async function main(){
    //Wallet where bob's identity is stored
    const wallet = await Wallets.newFileSystemWallet('../identity/user/Bob/wallet');

    //Gateway to acces the network
    const gateway = new Gateway();

    try{
        const userName = 'Bob';

        let connectionProfile = yaml.safeLoad(fs.readFileSync('../gateway/connection-org2.yaml', 'utf8'));

        let connectionOptions = {
            identity: userName,
            wallet: wallet,
            discovery: {enabled: true, asLocalhost: true}
        };

        console.log('Connect to the fabric gateway.');
        await gateway.connect(connectionProfile, connectionOptions);

        console.log('Use network channel : mychannel');
        const network = await gateway.getNetwork('mychannel');

        console.log('Use org.carmarket.car smart contract');
        const contract = await network.getContract('carcontract', 'org.carmarket.car');

        console.log('Submit car buy transaction');
        const buyResponse = await contract.submitTransaction('buy', 'Alice', '00001', 'Alice', 'Bob', '500');

        console.log('Process buy transaction response');
        let car = Car.fromBuffer(buyResponse);

        console.log(`${car.seller} car's : ${car.carNumber} successfully bought by ${car.owner} for ${car.price}$`)
        console.log('Transaction complete.')

    }catch (error) {

        console.log(`Error processing transaction. ${error}`);
        console.log(error.stack);

    } finally {

        // Disconnect from the gateway
        console.log('Disconnect from Fabric gateway.');
        gateway.disconnect();

    }
}
main().then(() => {

    console.log('Buy program complete.');

}).catch((e) => {

    console.log('Buy program exception.');
    console.log(e);
    console.log(e.stack);
    process.exit(-1);

});
