'use strict';

module.exports = settle;

function settle(promises) {
  return Promise
    .resolve(promises)
    .then(_settle);
}

function _settle(promises) {
  if (!Array.isArray(promises)) throw new TypeError('Expected an array of Promises');

  return Promise.all(promises.map(_settlePromise));
}

function _settlePromise(promise) {
  return Promise
    .resolve(promise)
    .then(_promiseResolved, _promiseRejected);
}

function _promiseResolved(result) {
  return {
    isFulfilled: _true,
    isRejected: _false,
    value: function () { return result; },
    reason: _isFulfilled
  };
}

function _promiseRejected(err) {
  return {
    isFulfilled: _false,
    isRejected: _true,
    value: _isRejected,
    reason: function () { return err; }
  };
}

function _true() {
  return true;
}

function _false() {
  return false;
}

function _isRejected() {
  throw new Error('Promise is rejected');
}

function _isFulfilled() {
  throw new Error('Promise is fulfilled');
}
