# TPE. Blockchain - HyperLedger Fabric | 2020 - 2021

## Auteur(s)

| Nom | Prénom | Email |
|-|-|-|
| *Bourgeaux* | *Maxence* | *maxence.bourgeaux@etu.univ-lehavre.fr* |
| *Guyomar* | *Robin* | *robin.guyomar@etu.univ-lehavre.fr* |
| *Kacimi* | *Souhail* | *souhail.kacimi@etu.univ-lehavre.fr* |

Ce TPE reprend le travail effectué par Amine Boussoualim l'année précédente (2019 - 2020). 

Son rapport est disponible 
sous format pdf et son travail est disponible à l'adresse suivante : https://www-apps.univ-lehavre.fr/forge/ba160129/tpeblockchain

# I. Installer les différents logiciels

**Prérequis**

La version actuelle du projet utilise HyperLedger fabric version 2.3.1.
Il est nécessaire d'avoir une version de Node <= 14 et de Docker compose <= 1.25 pour utiliser cette version d'HyperLedger
Fabric. 

Nos tests ont été effectués avec ces
versions :

![LogicielsVersions](Images/Tuto_Logiciels_Versions.PNG)

La suite du tutoriel proposera d'installer soit la version la plus récente, soit une version précise du logiciel.

**Se mettre à jour**

    sudo apt update
    sudo apt upgrade

**Installer git**

    sudo apt-get install git
    
**Installer cURL**    

    sudo apt install curl
    
**Installer la dernière version de Node.js et npm**    

    sudo apt install nodejs
    sudo apt install npm

**Installer une version précise de Node.js (en utilisant NVM)**
    
    curl -o- https://raw.githubusercontent.com/creationix/nvm/v0.33.11/install.sh | bash

Il faut ensuite copier la commande présente dans le terminal, puis le fermer et le réouvrir. Vérifiez que 
l'installation s'est bien effectuée :

    nvm --version

Puis regardez les différentes versions existantes et installez celle désirée (ici 14.15.4) :

    nvm ls-remote
    nvm install 14.15.4

**Docker et Docker Compose**

Installer la version la plus récente de Docker :

    sudo apt install docker-ce

Installer une version précise de Docker (pour une autre version, il suffit de changer 1.25.0 par la version désirée) :

    sudo curl -L "https://github.com/docker/compose/releases/download/1.25.0/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

Changez les permissions : 

    sudo chmod +x /usr/local/bin/docker-compose
    
Assurez-vous que le démon docker est en cours d'exécution :    

    sudo systemctl start docker

Facultatif : si vous souhaitez que le démon docker démarre au démarrage du système, exécutez la commande suivante :

    sudo systemctl enable docker
    
Ajoutez votre utilisateur au groupe Docker :   

    sudo usermod -a -G docker <username>
    
**Hyperledger Fabric**

Placez-vous dans le répertoire de votre choix et installer Hyperledger Fabric :

    curl -sSL https://bit.ly/2ysbOFE | bash -s

Ajoutez au fichier .bashrc la ligne suivante pour ajouter les variables d'environnement :

    export PATH=${PWD}/../bin:$PATH
    
Vous devez également définir le FABRIC_CFG_PATH :
    
    export FABRIC_CFG_PATH=$PWD/../config/
    
# II. Test du réseau Fabric

**Réseau de test**

Accédez au répertoire réseau de test :

    cd fabric-samples/test-network
    
Supprimez tous les conteneurs ou artefacts de toutes les exécutions précédentes :

    ./network.sh down    
    
Activez le réseau :

    ./network.sh up

Cela va créer un réseau de deux nœuds pairs (peer nodes) et d'un nœud commandeur (ordering node). Les nœuds pairs sont
les composants essentiels d'un réseau Fabric. Ce sont ces nœuds qui stockent le registre de la blockchain et valident
les transactions avant que le registre ne soit modifié. 

Vous allez pouvoir voir ces nœuds avec la prochaine commande.

**Les composants du réseau de test**

Affichez tous les conteneurs Docker qui s'exécutent sur votre ordinateur :

    docker ps -a

Vous devriez avoir un résultat similaire à :

![Tuto_DockerPsA](Images/Tuto_TestNetwork_DockerPS.PNG)

Chaque nœud pair qui intéragit avec le réseau doit appartenir à une organisation différente (org1, org2 ...). Le nœud
commandeur est celui qui va maintenir et diriger l'ordre des transactions du réseau.
Ce réseau de test créé ne dispose cependant d'aucune chaîne entre les différents nœuds.
    
# III. Fonctionnement du TPE 2020 - Vente d'un véhicule

**Créer le réseau**

Déplacez le répertoire VenteVoiture vers fabric-samples, puis ouvrez-le :

    cd fabric-samples/VenteVoiture

Exécutez le script pour démarrer le réseau de tests :

    ./network-starter.sh

Network-starter va d'abord exécuter la commande ./network.sh down afin de supprimer tout ce qui serait resté des exécutions
précédentes, puis va lancer la commande ./network.sh up createChannel -ca -s couchdb afin de créer un réseau de deux nœuds
pairs réliés entre eux et gérés par couchdb (Apache CouchDB est un système de gestion de base de données). L'option "-ca"
signifie "Certificate Authorities" et permet à chaque nœud d'avoir sa propre certification et ils partagent la même racine
de confiance. Le CA nous permet aussi de créer un certificat et une clé privée pour nos applications.
    
Lorsque le script est terminé, vous pouvez voir les nœuds Fabric s'exécutant sur votre machine :

    docker ps

![Tuto_DockerPs](Images/Tuto_NetworkStarter_DockerPS.PNG)
    
**Installer et approuver le contrat intelligent**

**(Alice)** Ouvrez un premier terminal et accédez au répertoire de la 1ère personne Alice :

    cd fabric-samples/VenteVoiture/organization/Alice

**(Alice)** Optionnel: Exécutez la commande suivante pour démarrer Logspout ("Logspout est un routeur de journaux open 
source conçu spécifiquement pour les journaux de conteneurs Docker. Il collecte les journaux de tous les autres conteneurs
fonctionnant sur le même hôte, puis les transmet à une destination de votre choix") :
    
    ./monitordocker.sh net_test
    
**(Alice)** Ouvrez un nouveau terminal si vous avez fait l'étape optionnelle, sinon exécutez le script pour définir les 
variables d'environnement :    

    source alice.sh

**(Alice)** Optionnel: Pour vérifier que vous pouvez bien utiliser Fabric Command Line Interface (CLI), exécutez la commande :
    
    peer version

![Tuto_PeerVersion](Images/Tuto_PeerVersion.PNG)
    
**(Alice)** Créez le package du chaincode (Archive le contrat intelligent en chaincode et l'écrit dans un fichier) :    

    peer lifecycle chaincode package car.tar.gz --lang node --path ./contract --label car_0

Cette commande va créer une archive nommée car.tar.gz. L'option --lang spécifie le langage de la chaincode, --path permet
de donner le chemin vers le contrat intelligent et --label permet de créer un label servant à identifier le chaincode après
son installation.
    
**(Alice)** Installez le chaincode au nœud:

    peer lifecycle chaincode install car.tar.gz

![Tuto_PackageAlice](Images/Tuto_CreationInstallation_Package_Alice.PNG)

Le contrat intelligent est désormais installé !
    
**(Alice)** Obtenez le packageID du chaincode pour ensuite approuver la définition du chaincode :

    peer lifecycle chaincode queryinstalled

**(Alice)** Enregistrez l'ID du package en tant que variable d'environnement :

    export PACKAGE_ID=car_0:7778fe966e1cfe11982c5f9d2d1a8eb1a225e4f547df8bac40ca50569fbd076d
    
**(Alice)** Approuvez la définition du chaincode pour l'organisation (for my organization):

    peer lifecycle chaincode approveformyorg --orderer localhost:7050 --ordererTLSHostnameOverride orderer.example.com --channelID mychannel --name carcontract -v 0 --package-id $PACKAGE_ID --sequence 1 --tls --cafile $ORDERER_CA

![Tuto_PackageID_Alice](Images/Tuto_PackageID_Alice.PNG)

On va maintenant faire la même chose pour Bob, c'est à dire installer et approuver le contrat de son côté.

**(Bob)** Ouvrez un second terminal et accédez au répertoire de la 2ème personne Bob :

    cd TPEBlockchain/VenteVoiture/organization/Bob
    
**(Bob)** Exécutez le script pour définir les variables d'environnement :    

    source bob.sh
    
**(Bob)** Créez le package du chaincode (Archive le contrat intelligent en chaincode et l'écrit dans un fichier) :    

    peer lifecycle chaincode package car.tar.gz --lang node --path ./contract --label car_0
    
**(Bob)** Installez le chaincode au nœud :

    peer lifecycle chaincode install car.tar.gz

![Tuto_PackageBob](Images/Tuto_CreationInstallation_Package_Bob.PNG)
    
**(Bob)** Obtenez le packageID du chaincode :

    peer lifecycle chaincode queryinstalled

**(Bob)** Enregistrez l'ID du package en tant que variable d'environnement :

    export PACKAGE_ID=car_0:7778fe966e1cfe11982c5f9d2d1a8eb1a225e4f547df8bac40ca50569fbd076d
    
**(Bob)** Approuvez la définition de la chaincode du contrat :

    peer lifecycle chaincode approveformyorg --orderer localhost:7050 --ordererTLSHostnameOverride orderer.example.com --channelID mychannel --name carcontract -v 0 --package-id $PACKAGE_ID --sequence 1 --tls --cafile $ORDERER_CA

![Tuto_PackageID_Bob](Images/Tuto_PackageID_Bob.PNG)

**(Alice)** Retournez sur le terminal correpondant à Alice et validez la définition du chaincode :

    peer lifecycle chaincode commit -o localhost:7050 --ordererTLSHostnameOverride orderer.example.com --peerAddresses localhost:7051 --tlsRootCertFiles ${PEER0_ORG1_CA} --peerAddresses localhost:9051 --tlsRootCertFiles ${PEER0_ORG2_CA} --channelID mychannel --name carcontract -v 0 --sequence 1 --tls --cafile $ORDERER_CA --waitForEvent

![Tuto_ValidationChaincode](Images/Tuto_ValidationChaincode.PNG)

Vous pouvez à tout moment vérifier que tout se passe correctement grâce au terminal où la commande ./monitoring net_test
à été effectuée.

**Vente de la voiture** 

**(Alice)** Accédez au répertoire application :

    cd application
    
**(Alice)** Installez les dépendances du contrat intelligent (cela va prendre un peu de temps ~ 1 min) :

    npm install

**(Alice)** Si des vulnérabilités sont présentes :

    npm audit fix
    
**(Alice)** Ajoutez des informations au portefeuilles (Wallet) :

    node addToWallet.js
    
**(Alice)** Mettez en vente la voiture :

    node sell.js

![Tuto_Sell_Alice](Images/Tuto_Sell_Alice.PNG)

**(Bob)** Retournez sur le terminal correpondant à Bob et accédez au répertoire application :

    cd application
    
**(Bob)** Installez les dépendances du contrat intelligent (cela va prendre un peu de temps ~ 1 min) :

    npm install

**(Bob)** Si des vulnérabilités sont présentes :

    npm audit fix
    
**(Bob)** Modifiez l'état de la voiture :

    node addToWallet.js
    
**(Bob)** Achetez la voiture :

    node buy.js

![Tuto_Buy_Bob](Images/Tuto_Buy_Bob.PNG)

**(Bob)** Constatez que le véhicule a bien changé de propriétaire :

    node info.js

![Tuto_InfoTransaction](Images/Tuto_InfoTransaction.PNG)

**Sources**

Pour plus de renseignements ou si des difficultés sont rencontrées, voici le lien vers la documentation
d'HyperLedger Fabric :

https://hyperledger-fabric.readthedocs.io/en/latest/tutorial/commercial_paper.html

# IV. Hyperledger Explorer

Hyperledger Explorer est un outil open source simple, puissant, facile à utiliser et bien entretenu pour parcourir l'activité sur le réseau blockchain.
Hyperledger Explorer fonctionne seulement sur MacOS et Ubuntu.

**Configurer Hyperledger Explorer**

La dernière version d'Hyperledger Explorer fonctionne avec la version 2.2 d'Hyperledger Fabric, si vous utilisez une autre version d'Hyperledger Fabric vous pourrez rencontrez des problèmes.
Vous pouvez consulter les dernières mises-à-jour d'Hyperledger Explorer sur le lien suivant : [Hyperledger Explorer](https://github.com/hyperledger/blockchain-explorer).

Pour lancer Hyperledger Explorer sur notre projet, lancer le réseau `./network-starter.sh`, placez-vous dans le dossier explorer. Puis tapez la commande `docker-compose up `.

Maintenant ouvrez votre navigateur sur http://localhost:8080/

![Hyperledger Explorer](Images/explorer.png)

Et voilà vous avez réussi à faire fonctionner Hyperledger Explorer, enfin pour arrêter Hyperledger Explorer tapez la commande `docker-compose down -v`.






