const { getInactiveSlaves, checkInactive } = require('./swarm');
const { SLAVE_GENERATION_NUMBER } = require('../entity/slave');
const hashModel = require('./mongo/hash');
const { sendSolutionToClients, sendDataToClients } = require('./comunication')

let autoRun = false;
let autoGenerateHashLength = 8;
const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
const charactersLength = characters.length;

/**
 * Genere et retourne un hash pour etre decrypté
 * @returns 
 */
function generateMD5Hash() {
    var result = '';
    for (var i = 0; i < autoGenerateHashLength; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    exec("echo -n " + result + " | md5sum", (err, stdout, stderr) => {
        if (err) {
            console.error(`error: ${err}`);
        } else {
            result = stdout
        }
    })
    return result;
}

/**
 * Decripte un hash en l'envoyant au slaves inactifs
 * @param {*} hash 
 */
function decryptMD5Hash(hash = generateMD5Hash()) {
    hashModel.findOne({ hash: hash }, function (err, obj) {
        if (err || obj === null) {
            checkInactive()
            let inactive = getInactiveSlaves();
            let workers = [];
            for (let i = 0; i < SLAVE_GENERATION_NUMBER; i++) {
                let current = inactive[i];
                let borne = getStarttoFinish(i)
                current.ws.send("search " + hash + " " + borne[0] + " " + borne[1]);
                current.active = true;
                console.log(hash + " was assinged to " + current.name);
                workers.push(current);
            }
            hashInSearch[hash] = workers;
        } else {
            sendSolutionToClients(obj.hash, obj.solution);
        }
    });

}

/**
 * Table des separation de lettre pour chaque slaves
 * @param {*} i 
 * @returns 
 */
function getStarttoFinish(i) {
    switch (i) {
        case 0:
            return ["a", "E"]
        case 1:
            return ["F", "9"]
        default:
            return ["a", "9"]
    }
}

/**
 * Boucle qui auto decrypte des hashs generée aleatoirement au une certaine vitesse
 * @param {*} speed 
 */
function autoDecrypt(speed) {
    while (autoRun) {
        decryptMD5Hash()
        sleep(speed)
    }
}

module.exports = { generateMD5Hash, decryptMD5Hash, autoDecrypt, getStarttoFinish }