const { exec } = require('child_process')
const express = require('express');
const app = express()
const expressWs = require('express-ws')(app);

const PORT = 3000
const SLAVE_GENERATION_NUMBER = 2


let autoRun = false
let slaveGroupeCount = 0


function autoDecrypt(speed) {
    while (autoRun) {
        decryptMD5Hash()
        sleep(speed)
    }
}

function decryptMD5Hash(hash = generateMD5Hash()) {
    slaves = createSlave()
    decryptMD5Hash(hash, slaves)
    killSlaves(slaves)
}

function createSlave() {
    for (let i = 0; i < SLAVE_GENERATION_NUMBER; i++) {
        exec('./hash_extractor s ws://localhost:' + PORT + "/slave/" + slaveGroupeCount)
        //search MD5_HASH BEGIN END
    }
    slaveGroupeCount++;
}



// Protocol HTML
app.get('/', (req, res) => {
    res.send('Hello World!')
})

app.get('/vlc', (req, res) => {
    exec('vlc')
    res.send('Hello World!')
})


// Protocol WS
app.ws('/echo', (ws, req) => {
    ws.on('message', (msg) => {
        console.log(msg)
        ws.send(msg);
    });
});

app.ws('/decrype', (ws, req) => {
    ws.on('message', (msg) => {
        console.log("Hash received : " + msg)
        decryptMD5Hash(msg)
    });
});

app.ws('/auto', (ws, req) => {
    ws.on('message', (msg) => {
        console.log("Auto mode enable")
        console.log("\tspeed : " + msg)
        autoRun = true
        switch (msg) {
            case "easy":
                autoDecrypt(60)
                break;
            case "medium":
                autoDecrypt(30)
                break;
            case "insane":
                autoDecrypt(10)
                break;
            case "off":
                console.log("Auto mode disable");
                autoRun = false;
                break;
            default:
                console.log("\tspeed not available !\nAuto mode disable")
                autoRun = false
                break;
        }
    });
});



var slaves = express.Router();

slaves.ws('/:slaveGroupeId', function (ws, req) {
    ws.on('message', function (msg) {
        console.log("slave : " + msg);
        res = msg.split(" ");
        if (res[0] == "found") {
            console.log(req.params.slaveGroupeId);
        }
        ws.send(msg);
    });
});

app.use("/slave", slaves);




const server = app.listen(PORT, () => {
    console.log(`App listening at http://localhost:${PORT}`);
    console.log(`WebSocket listening at ws://localhost:${PORT}`);
});

process.on('SIGINT', () => {
    for (let index = 0; index < slaveGroupeCount; index++) {
        app.ws('/slave/' + index, (ws, req) => {
            ws.send("stop");
            ws.send("exit");
        });
    }
    server.close(() => {
        console.log('\nServer closed - All Slaves killed');
        process.exit();
    });
});