let express = require('express');
let router = express.Router();

/* GET home page. */
router.get('/', function(req, res, next) {
    res.render('index', { title: 'Client' });
});


// Import net module.
let net = require('net');

// This function create and return a net.Socket object to represent TCP client.
function getConn(connName){

    let option = {
        host:'localhost',
        port: 9999
    }

    // Create TCP client.
    let client = net.createConnection(option, function () {
        console.log('Connection name : ' + connName);
        console.log('Connection local address : ' + client.localAddress + ":" + client.localPort);
        console.log('Connection remote address : ' + client.remoteAddress + ":" + client.remotePort);
    });

    client.setTimeout(1000);
    client.setEncoding('utf8');

    // When receive server send back data.
    client.on('data', function (data) {
        console.log('Server return data : ' + data);
    });

    // When connection disconnected.
    client.on('end',function () {
        console.log('Client socket disconnect. ');
    });

    client.on('timeout', function () {
        console.log('Client connection timeout. ');
    });

    client.on('error', function (err) {
        console.error(JSON.stringify(err));
    });

    return client;
}

// Create a java client socket.
let javaClient = getConn('Java');

// Create node client socket.
let nodeClient = getConn('Node');

let dockerClient = getConn('Docker');

javaClient.write('I\'m Java ');

nodeClient.write('I\'m Node');

dockerClient.write('I\'m Docker ');

module.exports = router;
