# Installation de Jenkins

Pour l'installation de Jenkins, nous avons choisi d'utilser un conteneur Dockerfile qui est un fichier qui contient l'ensemble des commandes nécessaires à la création d'un conteneur Docker.
[Dockerfile](img/Dockerfile.txt)

## Description de notre fichier Dockerfile

Récupération de l'image de base de Debian

    FROM debian:9.1
 
Installation des différents packages qui seront utilisés dans notre conteneur Docker comme par exemple Git ou le JDK8 de Java qui est utilisé dans Jenkins. 

    RUN apt-get update
    RUN apt-get -y install wget gnupg2 default-jre openjdk-8-jdk apt-transport-https git
 
Pour l'installation de Jenkins, il faut d'abord récupérer la clé publique SSH. Puis, il faut ajouter l'adresse du dépôt à la fin du fichier sources.list. Une mise à jour des depôts est effectuée avant d'installer le package Jenkins.

    RUN wget -q -O - http://pkg.jenkins.io/debian-stable/jenkins.io.key | apt-key add -
    RUN echo 'deb http://pkg.jenkins.io/debian-stable binary/' >> /etc/apt/sources.list
    RUN apt-get update
    RUN apt-get -y install jenkins
 
Ensuite, nous créons le fichier init.sh qui lancera Jenkins automatiquement à chaque démarrage du conteneur.

    RUN echo '#!/bin/bash \nservice jenkins start \necho '-- Wait for key generation --' \nsleep 5 \ncat /var/lib/jenkins/secrets/initialAdminPassword \necho 'Unlock security and restart container whith -d' \ntail -f /dev/null' >> /init.sh
    RUN echo '#!/bin/bash \nservice jenkins start \ntail -f /dev/null' >> /init.sh
    RUN chmod 777 /init.sh
 
Le port 8080 est ouvert avec EXPOSE

    CONFIG
    USER root
    EXPOSE 8080


    CONFIG autostart

Enfin, le ENTRYPOINT permet au conteneur de lancer le fichier init.sh à chaque démarrage.

    ENTRYPOINT ["/bin/bash", "--", "/init.sh"]
    
Une fois la création du conteneur finalisé, nous créons le volume qui lui sera attribué avec la commande suivante:

    sudo docker volume create --name jenkins_data
    

Sur le terminal, nous allons lancer Jenkins avec la commande. 

    docker-compose up

![dockerComposeUp](img/dockerComposeUp.png)


## Lancement de Jenkins dans le navigateur

Maintenant il suffit d'ouvrir notre navigateur et d'aller sur le localhost sur le port 8080. Jenkins demandera une clé et celle-ci est donnée sur le terminal. Il suffit de la copier-coller sur le site.

![jenkins-accueil-avant-passwd](img/jenkins-accueil-avant-passwd.png)

Ensuite, nous installons les plugins souhaités, ici nous allons nous contenter des plugins suggérés.

![plugins](img/demarrage.png)

Nous allons maintenant créer notre utilisateur.

![Utilisateur](img/utilisateur.png)

Cette étape conclue l’installation de Jenkins.

![jenkins-install-terminee](img/fin.png)


Section suivante &rarr; [Projet GitLab sur Jenkins](https://www-apps.univ-lehavre.fr/forge/dm091610/Toturiel_Docker_Jenkins/edit/master/src/IntegrationJenkins.md)
