# Intégration d'un projet GitLab sur Jenkins
Nous allons voir dans cette partie l'intégration et le test d'un projet de GitLab sous Jenkins.
Un mini programme écrit en Java et faisant des calculs nous servira d'exemple.

## Intégration sur Jenkins

* Sur la forge de l'Université GitLab, nous avons créé un projet (ProjetJavaDocker) afin de l'intégrer sous Jenkins.
Pour cela, nous allons copier le lien du projet GitLab.

![Copie Projet GitLab](img/GitCopieProjet.png)


* Ensuite, nous allons créer un projet sous Jenkins en cliquant sur le lien _Nouveau Item_ dans le tableau de bord.
Un nom doit être saisi (ici ProjetCalcul) et il faut cliquer sur _projet free style_.

![Création Projet Jenkins](img/JenkinsNewProjet.png)


* Nous allons commencer par ajouter une description à notre projet dans la rubrique _General_.

![Description Projet Jenkins](img/JenkinsDescription.png)


* Ce qui nous intéresse dans la rubrique _Gestion du code source_ c'est l'option **Git**. 
Cette option permet d'intégrer le projet GitLab (ici ProjetJavaDocker) sous Jenkins.
Nous allons en premier insérer le lien du projet GitLab. La branche du projet est automatiquement sélectionnée.

![Integration Projet GitLab](img/JenkinsRepository.png)


* Dans la rubrique _Build_ il faut cliquer sur le lien **Exécuter un script shell**.
Cette option permet d'insérer les lignes de code qui permettront d'exécuter et de tester l'application.

![Build Projet Jenkins](img/JenkinsBuild.png)

Dans notre cas le code à saisir est le suivant : 
  
    javac *.java       -- pour la compilation
    java CalculTest    -- pour l'exécution


* Enfin, il faut valider la création du projet et ce dernier sera ouvert sur l'interface de Jenkins comme suivant.
Notre projet ProjetJavaDocker sur GitLab est maintenant relié au projet ProjetCalcul sur Jenkins.

![Validation Projet Jenkins](img/JenkinsCreationTerminee.png)


## Test et Mise à jour du projet

* Nous allons maintenant tester notre projet ProjetCalcul. 
Les tests se font en cliquant sur le lien _Lancer un build_.
Cette action déclenche le script que nous avons précédemment inséré lors de la création du projet sur Jenkins.
L'historique des builds lancés se trouve en bas à gauche de la page.
Vous pouvez cliquer sur ces derniers afin d'avoir plus d'informations sur l'exécution de l'application.

![Lance Build Jenkins](img/JenkinsBuildLance.png)


* Sur l'image suivante nous voyons qu'en cliquant sur _Console Output_ nous avons le programme qui s'exécute et qui nous renvoie le résultat attendu.

![Console Projet Jenkins 1](img/JenkinsConsole1.png)


* Nous allons maintenant effectuer des modifications sur notre projet GitLab.
Cela nous permettra de vérifier si le projet de GitLab est bien relié au projet Jenkins.
Dans cet exemple, nous avons changé le code des fichiers Java afin de nous renvoyer un calcul différent à l'exécution.
Après avoir lancé un build du projet sur Jenkins, nous remarquons que les fichiers ont été modifiés.
Si nous cliquons sur les liens _details_, nous voyons clairement que des *commit* ont été effectués sur ce projet.

![Modification Projet GitLab](img/JenkinsChangementCode.png)

![Modification Projet GitLab](img/JenkinsCommitGit.png)

* Sur la console de Jenkins nous voyons bien que le résultat de l'exécution a aussi changé.

![Console Projet Jenkins 2](img/JenkinsConsole2.png)

Dorénavant tous les commits effectués sur le projet GitLab seront pris en compte sur Jenkins et cela aura des conséquences sur les tests.