# Installation de Docker & Docker-compose

Dans cette partie nous allons expliquer comment nous avons procéder pour l'installation de Docker et Docker_compose.
Cette installation s'est faite sur Ubuntu à partir du terminal.

## Installation de Docker

Docker est un logiciel libre qui permet d'automatiser la gestion d'applications dans un conteneur.  

Pour installer Docker nous allons ajouter la clé publique SSH du dépôt Docker par la commande :

     curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -

Puis, nous allons vérifier la clé obtenue par cette commande :

     sudo apt-key fingerprint 0EBFCD88
     
 ![key](img/key.png)
     

Ensuite nous allons ajouter Docker à la liste de notre dépôt :

    sudo add-apt-repository    "deb [arch=amd64] https://download.docker.com/linux/ubuntu \
                 $(lsb_release -cs) \     
                stable
            
Une mise à jour du dépôt sera effectué avec cette commande : 

    sudo apt-get update
   ![UPDATE](img/UPDATE.png)

Enfin, nous installons le package docker-ce :

    sudo apt-get install docker -ce
![DOCKER](img/DOCKER.png)

Une fois la création du conteneur faite, nous créons le volume puis nous installons le Docker_compose qui servira à lier deux images. 


## Installation de Docker-compose

D'abord, il faut exécuter cette commande pour télécharger la dernière version de Docker-compose :

        sudo curl -L "https://github.com/docker/compose/releases/download/1.22.0/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

 ![installation1](img/installation.png)

Ensuite, nous appliquons des autorisations pour les exécutables avec la commande : 

        sudo chmod +x /usr/local/bin/docker-compose
    
 ![auto](img/autorisation.png)

Enfin, nous vérifions si l'installation s'est effectuée correctement en demandant la version de Docker_compose avec la commande :

        docker-compose --version
        
![version](img/version.png)

Maintenant, nous allons créer un fichier appelé "docker-compose.yml" dans notre répertoire de projet :

        version: '3'
        services:
          web:
            build: .
            ports:
             - "8080:8080"
          redis:
            image: "debian"


Ce fichier Compose définit deux services, "web" et "redis" : 
* Le "web" service utilise une image construite à partir de "Dockerfile" dans le répertoire actuel.
On transfére le port expose 8080 sur le conteneur au port 8080 de la machine hôte.
* Le "redis" service utilise une image "Redis" publique extraite du registre de Docker Hub.(Dans notre projet c'est "debian")


À partir du répertoire de notre projet, nous démarrons notre application en exécutant : 

    docker-compose up

![compose](img/compose-up.png)


Section suivante &rarr; [Installation de Jenkins] (https://www-apps.univ-lehavre.fr/forge/dm091610/Toturiel_Docker_Jenkins/src/Jenkins.md)