# Installation de Jenkins

## Jenkins
Pour l'intallation de Jenkins, on a choisi d'utilser un conteneur Dockerfile qui est un fichier qui contient l'ensemble des commandes nécessaires pour la création d'un conteneur docker.

Description de notre fichier Dockerfile :

Récupération de l'image de base de debian

    FROM debian:9.1
 
Installation des différents packages qui vont étre utiliser dans notre conteneur docker comme par exemple Git ou jdk8 de java qui sera utilisé dans jenkins 

    RUN apt-get update
    RUN apt-get -y install wget gnupg2 default-jre openjdk-8-jdk apt-transport-https git
 
Pour l'installation de jenkins on commence par recupérer la clé publique ssh, on rajoute l'adresse du depots à la fin du fichier sources.list, on fait la mise à jour de nos depots puis on installe le package jenkins

    RUN wget -q -O - http://pkg.jenkins.io/debian-stable/jenkins.io.key | apt-key add -
    RUN echo 'deb http://pkg.jenkins.io/debian-stable binary/' >> /etc/apt/sources.list
    RUN apt-get update
    RUN apt-get -y install jenkins
 
On crée le fichier init.sh qui lancera jenkins automatiquement à chaque démarrage du conteneur

    RUN echo '#!/bin/bash \nservice jenkins start \necho '-- Wait for key generation --' \nsleep 5 \ncat /var/lib/jenkins/secrets/initialAdminPassword \necho 'Unlock security and restart container whith -d' \ntail -f /dev/null' >> /init.sh
    RUN echo '#!/bin/bash \nservice jenkins start \ntail -f /dev/null' >> /init.sh
    RUN chmod 777 /init.sh
 
On ouvre le port 8080 avec EXPOSE

    CONFIG
    USER root
    EXPOSE 8080


    CONFIG autostart

Enfin le ENTRYPOINT permet au conteneur à chaque démarrage de lancer le fichier inti.sh

    ENTRYPOINT ["/bin/bash", "--", "/init.sh"]
    
Une fois la crétion du conteneur est finalisé, on crée le volume qui lui associé avec la commande suivante:

    sudo docker volume create --name jenkins_data
    

Maintenant on va lancer Jenkins avec la commande 

    docker-compose up

Aprés on ouvre notre navigateur et aller sur le localhost sur le port 8080, Jenkins va demander une clé qu'on retrouvera sur le terminal. Il suffit de la copier-coller sur le site.

![jenkins-accueil-avant-passwd](img/jenkins-accueil-avant-passwd.png )

Ensuite on installe les plugins souhaités ici on va se contenter des plugins suggérés



maintenant il ne nous reste qu'a créer notre utilisateur


Section suivante &rarr; [Projet GitLab sur Jenkins] (https://www-apps.univ-lehavre.fr/forge/dm091610/Toturiel_Docker_Jenkins/edit/master/src/IntegrationJenkins.md)
