# Installation de Docker & Docker-compose

## Docker

Docker est un logiciel libre qui permet d'automatiser la gestion d'application dans un conteneur.  
Pour installer Docker nous allons ajouter la clé publique ssh du depot docker par la commande :

     curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -

apres nous allons vérifier la clé obtenu par cette commande :

     sudo apt-key fingerprint 0EBFCD88

ensuite on ajoute docker à la liste de notre depot  :

    sudo add-apt-repository    "deb [arch=amd64] https://download.docker.com/linux/ubuntu \
                 $(lsb_release -cs) \     
                stable
            
et on le met à jour par cette commande : 

    sudo apt-get update

et enfin on installe le package dokcer -ce :

    sudo apt-get install docker -ce

une fois la création du conteneur est faite, on crée le volume :   et on installe le docker_compose qui va servire a liée deux images :

    sudo docker volume create --name jenkins_data
    
pour afficher le volume : 

    sudo docker volume ls 

## Docker-compose

---Installer Compose sur les systèmes Linux ---

On exécute cette commande pour télécharger la dernière version de Docker Compose:

        sudo curl -L "https://github.com/docker/compose/releases/download/1.22.0/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

 ![installation1](img/installation.png)

On applique des autorisations exécutables au binaire avec la commande : 

        sudo chmod +x /usr/local/bin/docker-compose

On teste l'installation avec la commande :

        docker-compose --version

On crée un fichier appelé "docker-compose.yml" dans notre répertoire de projet :

        version: '3'
        services:
          web:
            build: .
            ports:
             - "8080:8080"
          redis:
            image: "debian"

Ce fichier Compose définit deux services, "web" et "redis".
Le "web" service:
Utilise une image construite à partir de "Dockerfile" dans le répertoire actuel.
On transfére le port exposé 8080 sur le conteneur au port 8080 sur la machine hôte.
Le "redis" service utilise une image "Redis" publique extraite du registre de Docker Hub.(Dans notre projet c'est "debian")


À partir du répertoire de notre projet, on démarre notre application en exécutant : 

    docker-compose up

Section suivante : [Installation de Jenkins] ()