const extraList = [
    { name: "Jantes alliage", price: 500 },
    { name: "Toit ouvrant", price: 1000 },
    { name: "Sièges chauffants", price: 400 },
    { name: "Radar de recul", price: 200 },
    { name: "Peinture métallisée", price: 600 },
    { name: "Pack hiver", price: 800 },
    { name: "GPS intégré", price: 300 },
    { name: "Caméra de recul", price: 150 },
    { name: "Système d'aide au stationnement", price: 450 },
    { name: "Autopilot", price: 2500 },
    { name: "Peinture premium", price: 1000 },
];

const cars = [
    generateCar(
        "img/1.jpg",
        "Renault",
        "Clio",
        "Voiture citadine 5 portes, année 2020",
        15000,
        "citadine",
        2020,
        10000,
        [extraList[0],extraList[3],extraList[4],extraList[6],extraList[8],extraList[9]]
    ),
    generateCar(
        "img/2.jpg",
        "Peugeot",
        "208",
        "Voiture citadine 5 portes, année 2021",
        16000,
        "citadine",
        2021,
        5000,
        [extraList[2],extraList[3]]
    ),
    generateCar(
        "img/3.jpg",
        "Volkswagen",
        "Golf",
        "Voiture compacte 5 portes, année 2022",
        25000,
        "compacte",
        2022,
        1000,
        [extraList[4],extraList[5]]
    ),
    generateCar(
        "img/4.jpg",
        "Ford",
        "Focus",
        "Voiture compacte 5 portes, année 2023",
        24000,
        "compacte",
        2023,
        8000,
        [extraList[0],extraList[1]]
    ),
    generateCar(
        "img/5.jpg",
        "Citroën",
        "C4",
        "Voiture compacte 5 portes, année 2020",
        22000,
        "compacte",
        2020,
        15000,
        [extraList[6],extraList[7]]
    ),
    generateCar(
        "img/6.jpg",
        "Toyota",
        "Yaris",
        "Voiture hybride 5 portes, année 2021",
        28000,
        "hybride",
        2021,
        2000,
        [extraList[4],extraList[8]]
    ),
    generateCar(
        "img/7.jpg",
        "Hyundai",
        "Ioniq",
        "Voiture électrique 5 portes, année 2022",
        35000,
        "electrique",
        2022,
        500,
        [extraList[0],extraList[1]]
    ),
    generateCar(
        "img/8.jpg",
        "Tesla",
        "Model 3",
        "Voiture électrique 4 portes, année 2023",
        50000,
        "electrique",
        2023,
        1000,
        [extraList[9],extraList[10]]
    ),
];

const app = document.getElementById('app');
let index = 0;
for (const car of cars) {
    if(car !== undefined)
    {
        index++;

        app.innerHTML +=  `<div class="col">
                            <div class="card h-100">
                                <div id="img-car-${index}"></div>
                                <div class="card-body">
                                    <h5 class="card-title">${car.make} ${car.model}</h5>
                                    <p class="card-text">${car.description}</p>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">Prix: ${car.price} €</li>
                                        <li class="list-group-item">Année:  ${car.year}</li>
                                        <li class="list-group-item">Kilométrage: ${car.mileage} </li>
                                     </ul>
                                     <button class="float-end btn btn-secondary" id="btn-car-${index}" data-index="${index-1}">-</button>
                                     <div id="body-car-${index}" class="body-extra"></div>
                                </div>
                            </div>
                        </div>`
    }
}
app.innerHTML += '</div>'


index =0;
for (const car of cars) {
    if(car !== undefined)
    {
        index++;

        if(car.generateImage !== undefined)
            car.generateImage(document.getElementById("img-car-"+ index));

        if(car.generateExtras !== undefined)
            car.generateExtras(document.getElementById("body-car-"+ index));
        document.getElementById("btn-car-"+ index).addEventListener('click',(event)=>{ showHideExtra(event.target,event.target.parentElement.querySelector('.body-extra'),cars[event.target.getAttribute('data-index')]) });

    }

}
