<?php

require_once 'PieceQuantik.php';
require_once 'ArrayPieceQuantik.php';
require_once 'PlateauQuantik.php';
require_once 'ActionQuantik.php';

function creerPiece(String $forme, String $couleur): PieceQuantik {
    switch($forme){
        case 'cube':
            if($couleur == 1){
                return PieceQuantik::initBlackCube();
            } else {
                return PieceQuantik::initWhiteCube();
            }
        case 'cone':
            if($couleur == 1){
                return PieceQuantik::initBlackCone();
            } else {
                return PieceQuantik::initWhiteCone();
            }
        case 'cylindre':
            if($couleur == 1){
                return PieceQuantik::initBlackCylindre();
            } else {
                return PieceQuantik::initWhiteCylindre();
            }
        case 'sphere':
            if($couleur == 1){
                return PieceQuantik::initBlackSphere();
            } else {
                return PieceQuantik::initWhiteSphere();
            }
    }
    return PieceQuantik::initVoid();
}

/* Construction du jeu */
$plateau = new PlateauQuantik();
$actions = new ActionQuantik($plateau);

/* Ajout des joueurs */
$j1 = "Le BG";
$j2 = "Adrien";

/* Initialisation de la variable pour savoir quand est-ce qu'on a un gagant. */
$perdant = true;

/* Initialisation de la variable pour savoir à qui le tour de jouer. 0 = j1, 1 = j2*/
$tour = 1;

/* Possibilités d'une pièce. */
$checkCoords = ['0', '1', '2', '3'];
$checkFormes = ["cone", "cube", "cylindre", "sphere"];
$checkColors = ['B', 'N'];

while($perdant){
    $tourValide = true;
    while($tourValide){
        /* Affichage du tour */
        if($tour === 1){
            echo "C'est au tour de " . $j1 . " de jouer !\n";
        } else{
            echo "C'est au tour de " . $j2 . " de jouer !\n";
        }
        /* Affichage du plateau */
        echo $actions->getPlateau();

        /* Récupère une abscisse valide. */
        $abs = '5';
        while(!in_array($abs, $checkCoords)) {
            echo "Veuillez entrer l'abscisse: ";
            $abs = fgets(STDIN);
        }
        $abs = intval($abs);

        /* Récupère une ordonnée valide. */
        $ord = '5';
        while(!in_array($ord, $checkCoords)) {
            echo "Veuillez entrer l'ordonnée: ";
            $ord = fgets(STDIN);
        }
        $ord = intval($ord);

        /* Récupère une forme valide. */
        $forme = 'BG';
        while(!in_array($forme, $checkFormes)) {
            echo "Veuillez entrer la Forme de votre pièce parmis (CUBE, CONE, CYLINDRE, SPHERE): ";
            $forme = trim(strtolower(fgets(STDIN)));
        }

        /* Récupère une couleur valide. */
        $couleur = '3';
        while(!in_array($couleur, $checkColors)) {
            echo "Veuillez entrer la couleur de votre pièce B -> Blanche, N -> Noire: ";
            $couleur = trim(strtoupper(fgets(STDIN)));
        }

        /* Traduction de 'B' et 'N' pour l'algorithme. */
        if($couleur == 'B'){
            $couleur = 0;
        } else{
            $couleur = 1;
        }

        $pieceCreee = creerPiece($forme, $couleur);
        if($actions->isValidePose($ord, $abs, $pieceCreee)){
            $actions->posePiece($ord, $abs, $pieceCreee);
            $tourValide = false;
            if($actions->isColWin($abs) || $actions->isRowWin($ord) || $actions->isCornerWin(PlateauQuantik::getCornerFromCoord($abs, $ord))){
                $perdant = false;
                switch($tour){
                    case 0:
                        echo "\n".$actions->getPlateau();
                        echo "\nFélicitations ! " . $j1 . " a gagné contre " . $j2 . " !";
                        break;
                    case 1:
                        echo "\n".$actions->getPlateau();
                        echo "\nFélicitations ! " . $j2 . " a gagné contre " . $j1 . " !";
                        break;
                }
            } else {
                echo "\n--------- Prochain Tour --------- \n";
            }
            /* Changement du tour. */
            $tour = ($tour + 1) % 2;
        }
    }


}