<?php

class QuantikUIGenerator extends AbstractUIGenerator{


    public function __construct(){

    }

    protected static function getButtonClass(PieceQuantik $piece): string{
       return "<button type='submit' name='active' disabled > $piece </button>";
    }

    protected static function getDivPlateauQuantik(PlateauQuantik $plateau): string{
        $html = "<div class='plateau'>";
        $html.= "<table>";
        for ($i = 0; $i < PlateauQuantik::NBROWS; $i++){
            $html.="<tr>";
            for($j = 0; $j < PlateauQuantik::NBCOLS; $j++){
                $html.= "<td>".$plateau->getPiece($i, $j)->__toString()."</td>";
            }
            $html.="</tr>";
        }
        $html.="</table></div>";
        return $html;
    }

    protected static function getDivPiecesDisponibles(ArrayPieceQuantik $apq):string
    {
        $html="";
        foreach ($apq as $piece){
            $html.= "<button type='submit' name='$piece->getForme().$piece->getCouleur()' disabled >$piece->__toString()</button>"; //eventuellement modifier nom
        }
        return $html;
    }


    protected static function getFormSelectionPiece(ArrayPieceQuantik $apq):string{
        $html = "<form action='traiteFormQuantik.php' method='post'>";
        $i = 0;
        foreach ($apq as $piece) {
            $html .= "<button type='submit' name='$i' >$piece</button>";
            $i++;
        }

        $html.="</form>";
        return $html;
    }
    
    protected static function getFormPlateauQuantik(PlateauQuantik $plateau, PieceQuantik $piece):string
    {
        $html= "<form action='traiteFormQuantik.php' method='post'>";
        $action = new ActionQuantik($plateau);
        for($i =0; $i < PlateauQuantik::NBROWS; $i++){
            for($j = 0; $j < PlateauQuantik::NBCOLS; $j++){
                if($action->isValidePose($i,$j, $piece)){
                    $html.="<button type='submit' class='vert' name='$i.:$j'>$piece</button>"; //: pour pouvoir split les coords
                }
                else{
                    $html.="<button type='submit' class='rouge' name='$i.$j' disabled>$piece</button>";
                }
            }
        }
        $html.="</from>";
        return $html;
    }

    protected static function getFormButtonAnnulerChoixPiece():string{
        $html= "<form action='selectPiece.php' method='post'>";
        $html.="<button type='submit' class='buttonAnnuler' name='annuler'>Annuler</button></form>";
        return $html;
    }

    protected static function getDivMessageVictoire(int $couleur): string{
        $color = "";
        if($couleur === PieceQuantik::WHITE){
            $color .= "Blancs";
        } else{
            $color .= "Noirs";
        }
        return "<div class='Victoire'> 
                    <p>  Victoire des $color </p>
                </div>";
    }

    protected  static function getLienRecommencer(): string{
        return "<a id='retry' href='index.php'>Recommencer</a>";
    }

    public static function getPageSelectionPiece(QuantikGame $quantik, int $couleurActive): string{
        $html = AbstractUIGenerator::getDebutHTML();
        $pieces = array();
        if($couleurActive == PieceQuantik::WHITE){
            $pieces = $quantik->piecesBlanches;
        } else{
            $pieces = $quantik->piecesNoires;
        }
        $html .= QuantikUIGenerator::getFormSelectionPiece($pieces);
        return $html .= AbstractUIGenerator::getFinHTML();
    }

    public static function getPagePosePiece(QuantikGame $quantik, int $couleurActive, int $posSelection): string{
        $html = AbstractUIGenerator::getDebutHTML();
        $pieces = array();
        if($couleurActive == PieceQuantik::WHITE){
            $pieces = $quantik->piecesBlanches;
        } else{
            $pieces = $quantik->piecesNoires;
        }
        $html .= QuantikUIGenerator::getFormPlateauQuantik($quantik->plateau, $pieces->getPieceQuantik($posSelection));
        return $html .= AbstractUIGenerator::getFinHTML();
    }

    public function getPagePoseVictoire(QuantikGame $quantik, int $couleurActive): string{
        $html = AbstractUIGenerator::getDebutHTML();
        $pieces = array();
        if($couleurActive == PieceQuantik::WHITE){
            $pieces = $quantik->piecesBlanches;
        } else{
            $pieces = $quantik->piecesNoires;
        }
        $html .= QuantikUIGenerator::getDivMessageVictoire($couleurActive);
        return $html .= AbstractUIGenerator::getFinHTML();
    }
}