<?php

class PieceQuantik{
    public const BLACK = 1;
    public const WHITE = 0;
    public const VOID = 0;
    public const CUBE = 1;
    public const CONE = 2;
    public const CYLINDRE = 3;
    public const SPHERE = 4;
    protected int $forme;
    protected int $couleur;

    private function __construct(int $forme, int $couleur){
        $this->forme = $forme;
        $this->couleur = $couleur;
    }

    public function getForme(): int{
        return $this->forme;
    }
    public function getCouleur(): int{
        return $this->couleur;
    }

    public function initVoid(): PieceQuantik{
        return new PieceQuantik(0,0);
    }

    public function WhiteCube(): PieceQuantik{
        return new PieceQuantik(1,0);
    }

    public function BlackCube(): PieceQuantik{
        return new PieceQuantik(1,1);
    }

    public function WhiteCone(): PieceQuantik{
        return new PieceQuantik(2,0);
    }

    public function BlackCone(): PieceQuantik{
        return new PieceQuantik(2,1);
    }

    public function WhiteCylindre(): PieceQuantik{
        return new PieceQuantik(3,0);
    }

    public function BlackCylindre(): PieceQuantik{
        return new PieceQuantik(3,1);
    }
    public function WhiteSphere(): PieceQuantik{
        return new PieceQuantik(4,0);
    }

    public function BlackSphere(): PieceQuantik{
        return new PieceQuantik(4,1);
    }

}