import React from "react";
import Link from "next/link";
import { AnnonceProps } from "@/lib/types/AnnonceProps";
import { Buffer } from "buffer";

export const CardAnnonce: React.FC<AnnonceProps> = ({
    id,
    titre,
    ville,
    pays,
    prix,
    imagePrincipale,
}) => {
  const formattedPrice = new Intl.NumberFormat("fr-FR", {
    style: "currency",
    currency: "EUR",
    minimumFractionDigits: 0,
  }).format(prix);

  const imageSrc = imagePrincipale
    ? `data:image/jpeg;base64,${Buffer.from(imagePrincipale).toString("base64")}`
    : "/default-image-annonce.jpg";

  return (
    <Link href={`/annonces/${id}`} className="block group">
      <div className="bg-white rounded-xl border border-gray-200 overflow-hidden transition-all duration-300 ease-in-out group-hover:shadow-lg group-hover:-translate-y-1">
        <div className="w-full h-48 bg-gray-100">
          <img src={imageSrc} alt={titre} className="w-full h-full object-cover"/>
        </div>

        <div className="p-5">
          <h3 className="text-lg font-semibold text-gray-900 truncate">{titre}</h3>
          <p className="text-sm text-gray-500 mt-1">{ville}, {pays}</p>
          <p className="text-xl font-bold text-gray-800 mt-4">{formattedPrice}</p>
        </div>
      </div>
    </Link>
  );
};
