import { prisma } from "@/lib/prismaClient";
import { Annonce } from "@prisma/client";

export const createAnnonce = async (data: { agentId: number, title: string, address: string, ville: string, codePostal: string, pays: string, description: string, prix: number, statut: string, createdAt: Date, updatedAt: Date }): Promise<Annonce> => {
    const annonce = await prisma.annonce.create({
        data: {
            agentId: data.agentId,
            title: data.title,
            address: data.address,
            ville: data.ville,
            codePostal: data.codePostal,
            pays: data.pays,
            description: data.description,
            prix: data.prix,
            statut: data.statut,
            createdAt: data.createdAt,
            updatedAt: data.updatedAt,
        },
    });
    return annonce;
};
