"use client";

import Link from "next/link";
import { useSession, signOut } from "next-auth/react";
import { useEffect, useState } from "react";
import { usePathname } from "next/navigation";

export default function Header() {
    const { data: session } = useSession();
    const pathname = usePathname();

    const active =
        pathname === "/"
            ? "home"
            : pathname?.startsWith("/annonces/rent")
              ? "rent"
              : pathname?.startsWith("/annonces/buy")
                ? "buy"
                : null;

    const firstName = session?.user?.firstName || "";
    const lastName = session?.user?.lastName || "";
    return (
        <header className="bg-primary relative z-50 flex-col items-center pr-0 pb-4 md:flex md:flex-row md:pr-6 md:pb-0">
            <div className="tw-flex border-secondary font-oswald mr-0 flex h-full w-full items-center justify-center border-b-5 pr-2 pl-6 md:mr-auto md:w-fit">
                <div className="flex items-center space-x-3">
                    <svg
                        preserveAspectRatio="xMidYMid meet"
                        data-bbox="7.767 51.693 183.51 85.375"
                        viewBox="7.767 51.693 183.51 85.375"
                        height="50"
                        width="50"
                        xmlns="http://www.w3.org/2000/svg"
                        data-type="color"
                        role="img"
                        aria-label="Page d'accueil">
                        <g>
                            <path
                                fill="#ffffff"
                                d="M178.752 121.175h-8V92.854l-42.739-31.219L99.51 82.877H29.201v38.298h-8V74.877h75.655l31.109-23.184 50.787 37.099v32.383z"
                                data-color="1"></path>
                            <path fill="#ffffff" d="M191.277 129.068v8H7.767v-8h183.51z" data-color="1"></path>
                            <path fill="#ffffff" d="M131.794 91.26v15.298h-8V91.26h8z" data-color="1"></path>
                            <path fill="#ffffff" d="M75.724 91.26v15.298h-8V91.26h8z" data-color="1"></path>
                            <path fill="#ffffff" d="M51.213 91.26v15.298h-8V91.26h8z" data-color="1"></path>
                        </g>
                    </svg>
                    <Link href="/" className="text-2xl font-bold text-white">
                        Immo<span className="text-gray-400">Next</span>
                    </Link>
                </div>
            </div>

            <nav>
                <ul className="mt-4 flex items-center justify-center space-x-4 font-(--font-roboto-thin) text-white md:mt-0">
                    <li>
                        <Link href="/" className={`${active === "home" ? "text-secondary" : ""} `}>
                            Accueil
                        </Link>
                    </li>
                    <li>
                        <Link
                            href="/annonces/rent"
                            className={`hover:text-secondary transition-colors duration-200 ease-in-out hover:cursor-pointer ${
                                active === "rent" ? "text-secondary" : ""
                            }`}>
                            Locations
                        </Link>
                    </li>
                    <li>
                        <Link
                            href="/annonces/buy"
                            className={`hover:text-secondary transition-colors duration-200 ease-in-out hover:cursor-pointer ${
                                active === "buy" ? "text-secondary" : ""
                            }`}>
                            Achats
                        </Link>
                    </li>
                    {session ? (
                        <>
                            <li className="group relative text-white sm:block">
                                <div className="cursor-pointer">
                                    {firstName} {lastName}
                                </div>

                                <div className="pointer-events-none absolute inset-0 top-full h-2 w-full group-hover:pointer-events-auto"></div>

                                <div className="bg-primary invisible absolute top-full right-0 mt-2 w-full translate-y-1 rounded-md opacity-0 shadow-lg transition-all duration-150 ease-out group-hover:visible group-hover:translate-y-0 group-hover:opacity-100">
                                    <button
                                        onClick={() => signOut()}
                                        className="hover:text-secondary w-full px-4 py-2 text-left text-white transition-colors duration-200 ease-in-out hover:cursor-pointer">
                                        Déconnexion
                                    </button>
                                </div>
                            </li>
                            <li></li>
                        </>
                    ) : (
                        <>
                            <li>
                                <Link
                                    href="/login"
                                    className="hover:text-secondary transition-colors duration-200 ease-in-out hover:cursor-pointer">
                                    Se connecter
                                </Link>
                            </li>
                            <li>
                                <Link
                                    href="/register"
                                    className="hover:text-secondary transition-colors duration-200 ease-in-out hover:cursor-pointer">
                                    S'inscrire
                                </Link>
                            </li>
                        </>
                    )}
                </ul>
            </nav>
        </header>
    );
}
