import type { $Enums, Question } from "@prisma/client";
import { GalleryImg } from "./GalleryImgeProp";
import { QuestionProp } from "./QuestionProp";
import { UserProps } from "./UserProps";

export type Statut = $Enums.Statut;

export interface AnnonceProps {
    id: number;
    title: string;
    address: string;
    city: string;
    postalCode: string;
    country: string;
    description: string;
    price: number;
    mainImg?: string | null;
    statut: Statut;
    questions?: QuestionProp[];
    agent: UserProps;
}

export interface AnnonceWithIncludes extends AnnonceProps {
    gallery: GalleryImg[];
    questions: QuestionProp[];
    agent: UserProps;
}