import React from "react";
import Link from "next/link";
import { AnnonceProps } from "@/lib/types/AnnonceProps";

export const CardAnnonce: React.FC<AnnonceProps> = ({ id, title, city, country, price, mainImg }) => {
    const formattedPrice = new Intl.NumberFormat("fr-FR", {
        style: "currency",
        currency: "EUR",
        minimumFractionDigits: 0,
    }).format(price);

    const imageSrc = mainImg ? `data:image/jpeg;base64,${mainImg}` : "/default-image-annonce.jpg";

    return (
        <Link href={`/annonces/${id}`} className="group block">
            <div className="overflow-hidden rounded-xl border border-gray-200 bg-white transition-all duration-300 ease-in-out group-hover:-translate-y-1 group-hover:shadow-lg">
                <div className="h-48 w-full bg-gray-100">
                    <img src={imageSrc} alt={title} className="h-full w-full object-cover" />
                </div>

                <div className="p-5">
                    <h3 className="truncate text-lg font-semibold text-gray-900">{title}</h3>
                    <p className="mt-1 text-sm text-gray-500">
                        {city}, {country}
                    </p>
                    <p className="mt-4 text-xl font-bold text-gray-800">{formattedPrice}</p>
                </div>
            </div>
        </Link>
    );
};
