import { getAllAnnonces } from "@/lib/services/annonceService";
import { CardAnnonce } from "@/lib/components/annonceComponent";
import Link from "next/link";
import { getServerSession } from "next-auth/next";
import { authOptions } from "@/app/api/auth/[...nextauth]/route";
import { Statut as PrismaStatut } from "@prisma/client";

export default async function Home() {
    const session = await getServerSession(authOptions);
    const annonces = await getAllAnnonces();
    return (
        <div className="min-h-screen bg-white">
            <div className="container mx-auto p-4 sm:p-6 lg:p-8">
                {/* Header et Navigation */}
                <header className="mb-10 flex items-center justify-between border-b border-gray-200 py-4">
                    <Link href="/" className="text-2xl font-bold text-gray-900">
                        Immo<span className="text-gray-500">Next</span>
                    </Link>
                    <nav>
                        <ul className="flex items-center space-x-4">
                            {session ? (
                                <>
                                    <li className="hidden text-gray-600 sm:block">
                                        Bonjour,{" "}
                                        <strong className="font-bold font-medium text-gray-900">
                                            {session.user?.firstName} {session.user?.lastName} !
                                        </strong>
                                    </li>
                                    <li>
                                        <Link
                                            href="/api/auth/signout"
                                            className="text-sm font-medium text-gray-600 transition-colors hover:text-black"
                                        >
                                            Se déconnecter
                                        </Link>
                                    </li>
                                </>
                            ) : (
                                <>
                                    <li>
                                        <Link
                                            href="/login"
                                            className="text-sm font-medium text-gray-600 transition-colors hover:text-black"
                                        >
                                            Se connecter
                                        </Link>
                                    </li>
                                    <li>
                                        <Link
                                            href="/register"
                                            className="rounded-md bg-gray-900 px-4 py-2 text-sm font-medium text-white transition-colors hover:bg-black"
                                        >
                                            S'inscrire
                                        </Link>
                                    </li>
                                </>
                            )}
                        </ul>
                    </nav>
                </header>

                {/* Titre */}
                <section className="mb-16 text-center">
                    <h1 className="mb-4 text-4xl font-extrabold text-gray-900 md:text-5xl">
                        La propriété de vos rêves
                    </h1>
                    <p className="mx-auto max-w-2xl text-lg text-gray-500">
                        Parcourez nos annonces exclusives et trouvez le bien qui vous attend.
                    </p>
                </section>

                {/* Annonces */}
                <main className="grid grid-cols-1 gap-8 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                    {annonces
                        .filter((a) => a.statut === PrismaStatut.PUBLISHED)
                        .map((a) => (
                            <CardAnnonce key={a.id} {...a} />
                        ))}
                </main>
            </div>
        </div>
    );
}
