import { prisma } from "@/lib/prismaClient";
import { User } from "@prisma/client";
import { bcrypt } from "bcryptjs";

export const createUser = async (data: { email: string, firstname: string, lastname: string, password: string, dob: Date }): Promise<User> => {
    const hashedPassword = await bcrypt.hash(data.password, 10);
    const user = await prisma.user.create({
        data: {
            email: data.email,
            firstName: data.firstname,
            lastName: data.lastname,
            password: hashedPassword,
            dob: data.dob,
        },
    });
    return user;
};

export const 