import { Annonce } from "@prisma/client";
import prisma from "@/lib/globalPrisma";

export const createAnnonce = async (data: { agentId: number, title: string, address: string, ville: string, codePostal: string, pays: string, description: string, prix: number }): Promise<Annonce> => {
    const annonce = await prisma.annonce.create({
        data: {
            agentId: data.agentId,
            titre: data.title,
            address: data.address,
            ville: data.ville,
            codePostal: data.codePostal,
            pays: data.pays,
            description: data.description,
            prix: data.prix,
        },
    });
    return annonce;
};
