import { getAllAnnonces } from "@/lib/services/annonceService";
import { CardAnnonce } from "@/lib/components/annonceComponent";
import Link from 'next/link';
import { getServerSession } from 'next-auth/next';
import { authOptions } from '@/app/api/auth/[...nextauth]/route';

export default async function Home() {
  const session = await getServerSession(authOptions);
  const annonces = await getAllAnnonces();
  return (
    <div className="font-sans grid min-h-screen p-8 sm:p-20 mt-20">
      <header>
        <nav className="py-2">
          <ul className="flex items-center space-x-4">
            {/* --- 5. Rendu conditionnel de la navigation --- */}
            {session ? (
              // Utilisateur connecté => on montre ses datas
              <>
                <li className="text-gray-700">
                  Bonjour, <strong>{session.user?.firstName}</strong> !
                </li>
                <li>
                  {/* Ce lien spécial déclenche la déconnexion gérée par NextAuth */}
                  <Link href="/api/auth/signout" className="border rounded px-4 py-2 block bg-red-500 text-white hover:bg-red-600">
                    Se déconnecter
                  </Link>
                </li>
              </>
            ) : (
              // Si l'utilisateur n'est pas connecté => page par défaut
              <>
                <li>
                  <Link href="/login" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                    Se connecter
                  </Link>
                </li>
                <li>
                  <Link href="/register" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                    S'inscrire
                  </Link>
                </li>
              </>
            )}
          </ul>
        </nav>
        <h1 className="text-4xl font-bold mb-4 mt-8">Liste des Annonces</h1>
        <p className="text-lg text-gray-600">Découvrez toutes les annonces disponibles.</p>
      </header>

      {/* --- 6. Affichage des annonces (code simplifié) --- */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 justify-items-center mt-8">
        {annonces.map((annonce) => (
          <CardAnnonce
            key={annonce.id}
            id={annonce.id}
            agentId={annonce.agentId}
            titre={annonce.titre}
            address={annonce.address}
            ville={annonce.ville}
            codePostal={annonce.codePostal}
            pays={annonce.pays}
            description={annonce.description}
            prix={annonce.prix}
            createdAt={annonce.createdAt}
            updatedAt={annonce.updatedAt}
          />
        ))}
      </div>
    </div>
  );
}