"use client";

import { useState } from "react";

import type { AnnonceProps } from "@/lib/types/AnnonceProps";
import type { GalleryImg } from "@/lib/types/GalleryImgeProp";
import EditAnnonceForm from "@/app/annonces/edit/[id]/EditAnnonceForm";
import EditAnnonceMainImg from "@/app/annonces/edit/[id]/EditAnnonceMainImg";
import EditAnnonceOtherImg from "@/app/annonces/edit/[id]/EditAnnonceOhterImg";

type Props = {
    annonce: AnnonceProps;
    annonceId: number;
    gallery: GalleryImg[] | undefined;
};

type Tab = "form" | "main" | "gallery";

export default function EditAnnonceSwitcher({ annonce, annonceId, gallery }: Props) {
    const [active, setActive] = useState<Tab>("form");

    const btnBase = "px-4 py-2 text-sm font-medium border transition-colors";
    const btnActive = "bg-gray-900 text-white border-gray-900";
    const btnIdle = "bg-white text-gray-800 border-gray-300 hover:bg-gray-100";

    return (
        <div className="mx-auto max-w-5xl p-4">
            <div className="mb-6 flex justify-center gap-2">
                <button
                    type="button"
                    className={`${btnBase} ${active === "form" ? btnActive : btnIdle}`}
                    onClick={() => setActive("form")}>
                    Informations
                </button>
                <button
                    type="button"
                    className={`${btnBase} ${active === "main" ? btnActive : btnIdle}`}
                    onClick={() => setActive("main")}>
                    Photo principale
                </button>
                <button
                    type="button"
                    className={`${btnBase} ${active === "gallery" ? btnActive : btnIdle}`}
                    onClick={() => setActive("gallery")}>
                    Galerie
                </button>
            </div>

            <div className="relative w-full">
                <div className={active === "form" ? "block" : "hidden"}>
                    <EditAnnonceForm annonce={annonce} />
                </div>

                <div className={active === "main" ? "block" : "hidden"}>
                    <EditAnnonceMainImg annonce={annonce} />
                </div>

                <div className={active === "gallery" ? "block" : "hidden"}>
                    <EditAnnonceOtherImg annonceId={annonceId} annonceGallery={gallery} />
                </div>
            </div>
        </div>
    );
}
