'use client';
import React from "react";
import Link from "next/link";

export default function Register() {
    return (
        <div className="min-h-screen bg-gray-50 flex flex-col justify-center items-center p-4">
            <div className="max-w-md w-full mx-auto">
                <div className="text-center mb-8">
                    <Link href="/" className="text-3xl font-bold text-gray-900">
                        Immo<span className="text-gray-500">Next</span>
                    </Link>
                    <h2 className="mt-6 text-3xl font-extrabold text-gray-900">Créer un compte</h2>
                    <p className="mt-2 text-sm text-gray-600">
                        Déjà membre ?{' '}
                        <Link href="/login" className="font-medium text-gray-800 hover:text-black underline">
                            Connectez-vous
                        </Link>
                    </p>
                </div>

                <div className="bg-white p-8 border border-gray-200 rounded-xl shadow-sm">
                    <form className="space-y-6">
                        {/* form */}
                        <div>
                            <label htmlFor="firstname" className="block text-sm font-medium text-gray-700">Prénom</label>
                            <input id="firstname" type="text" required className="mt-1 block w-full px-3 py-2 border border-gray-300 text-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500" />
                        </div>
                        { }
                        <div>
                            <button type="submit" className="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-gray-900 hover:bg-black focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black">
                                S'inscrire
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    );
}