// src/app/page.tsx
import { getAllAnnonces } from "@/lib/services/annonceService";
import { CardAnnonce } from "@/lib/components/annonceComponent";
import Link from 'next/link';
import { getServerSession } from 'next-auth/next';
import { authOptions } from '@/app/api/auth/[...nextauth]/route';

export default async function Home() {
  const session = await getServerSession(authOptions);
  const annonces = await getAllAnnonces();

  return (
    <div className="bg-white min-h-screen">
      <div className="container mx-auto p-4 sm:p-6 lg:p-8">
        {/* Header et Navigation */}
        <header className="flex justify-between items-center py-4 mb-10 border-b border-gray-200">
          <Link href="/" className="text-2xl font-bold text-gray-900">
            Immo<span className="text-gray-500">Next</span>
          </Link>
          <nav>
            <ul className="flex items-center space-x-4">
              {session ? (
                <>
                  <li className="text-gray-600 hidden sm:block">
                    Bonjour, <strong className="font-medium text-gray-900 font-bold">{session.user?.firstName} {session.user?.lastName} !</strong>
                  </li>
                  <li>
                    <Link href="/api/auth/signout" className="text-sm font-medium text-gray-600 hover:text-black transition-colors">
                      Se déconnecter
                    </Link>
                  </li>
                </>
              ) : (
                <>
                  <li>
                    <Link href="/login" className="text-sm font-medium text-gray-600 hover:text-black transition-colors">
                      Se connecter
                    </Link>
                  </li>
                  <li>
                    <Link href="/register" className="text-sm font-medium text-white bg-gray-900 hover:bg-black px-4 py-2 rounded-md transition-colors">
                      S'inscrire
                    </Link>
                  </li>
                </>
              )}
            </ul>
          </nav>
        </header>

        {/* Titre */}
        <section className="text-center mb-16">
          <h1 className="text-4xl md:text-5xl font-extrabold text-gray-900 mb-4">La propriété de vos rêves</h1>
          <p className="text-lg text-gray-500 max-w-2xl mx-auto">Parcourez nos annonces exclusives et trouvez le bien qui vous attend.</p>
        </section>

        {/* Annonces */}
        <main className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
          {annonces.map((annonce) => (
            <CardAnnonce key={annonce.id} {...annonce} />
          ))}
        </main>
      </div>
    </div>
  );
}