"use client";
import { useState, useEffect, useRef } from "react";
import { CardAnnonce } from "../annonceCardComponent";

type whereToFetch = {
    type: string;
};

export default function CardList({ type }: whereToFetch) {
    const [annonces, setAnnonces] = useState<any[]>([]);
    const [cursor, setCursor] = useState<number | undefined>();
    const [hasMore, setHasMore] = useState(false);
    const [isLoading, setIsLoading] = useState(false);

    const didInit = useRef(false);
    const loadingRef = useRef(false);

    async function loadMore() {
        if (loadingRef.current) return;
        loadingRef.current = true;
        setIsLoading(true);
        try {
            const res = await fetch(`/api/annonces/${type}?limit=4${cursor ? `&cursor=${cursor}` : ""}`, { cache: "no-store" });
            const data = await res.json();

            setAnnonces((prev) => {
                const byId = new Map<number, any>(prev.map((a) => [a.id, a]));
                for (const it of data.items) byId.set(it.id, it);
                return Array.from(byId.values());
            });

            setCursor(data.nextCursor);
            setHasMore(Boolean(data.hasMore));
        } finally {
            setIsLoading(false);
            loadingRef.current = false;
        }
    }

    useEffect(() => {
        if (didInit.current) return;
        didInit.current = true;
        loadMore();
    }, []);

    return (
        <div className="w-full flex flex-col items-center justify-center gap-24">
            <div className="flex w-full flex-col flex-wrap items-center justify-center md:justify-between gap-8 md:flex-row max-w-[1600px]">
                {annonces.length === 0 ? (
                    <p className="mt-8 text-center text-gray-500 mb-[500px]">Aucune annonce disponible pour le moment.</p>
                ) : (
                    annonces.map((a) => (
                        <div key={a.id} className=" min-w-[260px] w-full md:w-1/5">
                            <CardAnnonce {...a} />
                        </div>
                    ))
                )}
                </div>
                <div>
                {hasMore && annonces.length > 0 && (
                    <button
                        onClick={loadMore}
                        disabled={isLoading}
                        className="rounded bg-gray-800 px-4 py-2 text-white hover:bg-gray-700 disabled:opacity-60">
                        {isLoading ? "Chargement..." : "Voir plus"}
                    </button>
                )}
            </div>
        </div>
    );
}
