import { Annonce } from "@prisma/client";
import prisma from "@/lib/globalPrisma";

export const createAnnonce = async (data: { agentId: number, title: string, address: string, ville: string, codePostal: string, pays: string, description: string, prix: number }): Promise<Annonce> => {
    const annonce = await prisma.annonce.create({
        data: {
            agentId: data.agentId,
            titre: data.title,
            address: data.address,
            ville: data.ville,
            codePostal: data.codePostal,
            pays: data.pays,
            description: data.description,
            prix: data.prix,
        },
    });
    return annonce;
};

export const getAnnonceById = async (id: number): Promise<Annonce | null> => {
    return await prisma.annonce.findUnique({
        where: { id },
    });
}

export const updateAnnonce = async (id: number, data: { title?: string, address?: string, ville?: string, codePostal?: string, pays?: string, description?: string, prix?: number }): Promise<Annonce> => {
    return await prisma.annonce.update({
        where: { id },
        data: {
            titre: data.title,
            address: data.address,
            ville: data.ville,
            codePostal: data.codePostal,
            pays: data.pays,
            description: data.description,
            prix: data.prix,
        },
    });
}

export const deleteAnnonce = async (id: number): Promise<Annonce> => {
    return await prisma.annonce.delete({
        where: { id },
    });
}
