import { NextRequest, NextResponse } from 'next/server';
import { createAnnonce, getAllAnnonces } from '@/lib/services/annonceService';
import { writeFile } from 'fs/promises';
import path from 'path';

export async function POST(req: NextRequest) {
    try {
        const formData = await req.formData();

        const agentId = formData.get('agentId') as string;
        const title = formData.get('title') as string;
        const address = formData.get('address') as string;
        const pays = formData.get('pays') as string;
        const ville = formData.get('ville') as string;
        const codePostal = formData.get('codePostal') as string;
        const description = formData.get('description') as string;
        const prix = formData.get('prix') as string;
        const images = formData.getAll('images') as File[];

        if (!agentId || !title || !prix || images.length === 0) {
            return NextResponse.json({ message: "Les champs requis sont manquants." }, { status: 400 });
        }

        const annonces = await getAllAnnonces();
        const maxId = Math.max(...annonces.map(a => a.id), 0);
        const newAnnonceId = maxId + 1;

        const imageUrls: string[] = [];

        const uploadDir = path.join(process.cwd(), 'public', 'annonces', String(newAnnonceId));

        const fs = require('fs');
        if (!fs.existsSync(uploadDir)) {
            fs.mkdirSync(uploadDir, { recursive: true });
        }

        for (const image of images) {
            const buffer = Buffer.from(await image.arrayBuffer());
            const filename = `${Date.now()}_${image.name.replaceAll(" ", "_")}`;
            const filePath = path.join(uploadDir, filename);

            await writeFile(filePath, buffer);

            imageUrls.push(`/annonces/${newAnnonceId}/${filename}`);
        }

        const newAnnonce = await createAnnonce({
            agentId: Number(agentId),
            title,
            address,
            pays,
            ville,
            codePostal,
            description,
            prix: Number(prix),
            images: imageUrls,
        });

        return NextResponse.json(newAnnonce, { status: 201 });

    } catch (error) {
        console.error("Erreur API lors de la création de l'annonce:", error);
        return NextResponse.json({ message: "Erreur interne du serveur." }, { status: 500 });
    }
}