import { getServerSession } from 'next-auth/next';
import { authOptions } from '@/app/api/auth/[...nextauth]/route';
import CreateAnnonceForm from './CreateAnnonceForm';

export default async function CreateAnnoncePage() {
    const session = await getServerSession(authOptions);
    if (!session || session.user?.role === 'USER') {
        return (
            <div className="min-h-screen flex flex-col justify-center items-center p-4">
                <div className="max-w-md w-full mx-auto text-center">
                    <h2 className="text-2xl font-bold text-gray-900 mb-4">Accès refusé</h2>
                    <p className="text-gray-600 mb-6">Vous devez être connecté en tant qu'agent immobilier pour ajouter une annonce.</p>
                </div>
            </div>
        );
    }

    return (
        <CreateAnnonceForm user={session.user as any} />
    );
}