import React from "react";
import { AnnonceProps } from "@/lib/types/AnnonceProps";

export const CardAnnonce: React.FC<AnnonceProps> = ({
    id,
    titre,
    address,
    ville,
    codePostal,
    pays,
    description,
    prix,
    createdAt,
    updatedAt
}) => {
    return (
        <div className="border p-4 rounded shadow-md bg-white-200">
            <h3>{titre}</h3>
            <p>{address}, {ville} {codePostal}, {pays}</p>
            <p>{description}</p>
            <p>Prix: {prix}€</p>
            <small>Créé: {createdAt.toLocaleDateString()} — Mis à jour: {updatedAt.toLocaleDateString()}</small>
        </div>
    );
}