import { getAllAnnonces } from "@/lib/services/annonceService";
import { CardAnnonce } from "@/lib/components/annonceComponent";
import Link from 'next/link';

export default function Home() {
  const annonces = getAllAnnonces();
  return (
    <div className="font-sans grid min-h-screen p-8 sm:p-20 mt-20">
      <header>
        <nav className="py-2">
          <ul className="flex space-x-4">
            <li>
              <Link href="/login" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                Se connecter
              </Link>
            </li>
            <li>
              <Link href="/register" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                S'inscrire
              </Link>
            </li>
          </ul>
        </nav>
        <h1 className="text-4xl font-bold mb-4">Liste des Annonces</h1>
        <p className="text-lg text-gray-600">Découvrez toutes les annonces disponibles.</p>
      </header>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 justify-items-center">
        {annonces.then((data) =>
          data.map((annonce) => (
            <CardAnnonce
              key={annonce.id}
              id={annonce.id}
              agentId={annonce.agentId}
              titre={annonce.titre}
              address={annonce.address}
              ville={annonce.ville}
              codePostal={annonce.codePostal}
              pays={annonce.pays}
              description={annonce.description}
              prix={annonce.prix}
              createdAt={annonce.createdAt}
              updatedAt={annonce.updatedAt}
            />
          ))
        )}
      </div>
    </div >
  );
}
