import Link from 'next/link';

export default function Login() {
    return (
        <div className="font-sans grid min-h-screen p-8 sm:p-20 mt-20">
            <header>
                <nav className="py-2">
                    <ul className="flex space-x-4">
                        <li>
                            <Link href="/" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                                Accueil
                            </Link>
                        </li>
                        <li>
                            <Link href="/register" className="border rounded px-4 py-2 block hover:bg-gray-200 hover:text-gray-800">
                                S'inscrire
                            </Link>
                        </li>
                    </ul>
                </nav>
                <h1 className="text-4xl font-bold mb-4">Connexion</h1>
                <p className="text-lg text-gray-600">Veuillez vous connecter pour accéder à votre compte.</p>
            </header>
        </div>
    );
}
