// src/app/login/page.tsx
'use client';

import Link from 'next/link';
import { useState } from 'react';
import { signIn } from 'next-auth/react';
import { useRouter } from 'next/navigation';

export default function Login() {
    const [email, setEmail] = useState('');
    const [password, setPassword] = useState('');
    const [error, setError] = useState<string | null>(null);
    const router = useRouter();

    const handleSubmit = async (event: React.FormEvent<HTMLFormElement>) => {
        event.preventDefault();
        setError(null);
        const result = await signIn('credentials', {
            redirect: false, email, password,
        });
        if (result?.error) setError("L'adresse e-mail ou le mot de passe est incorrect.");
        else if (result?.ok) router.push('/');
    };

    return (
        <div className="min-h-screen bg-gray-50 flex flex-col justify-center items-center p-4">
            <div className="max-w-md w-full mx-auto">
                <div className="text-center mb-8">
                    <Link href="/" className="text-3xl font-bold text-gray-900">
                        Immo<span className="text-gray-500">Next</span>
                    </Link>
                    <h2 className="mt-6 text-3xl font-extrabold text-gray-900">Bienvenue</h2>
                    <p className="mt-2 text-sm text-gray-600">
                        Nouveau ici ?{' '}
                        <Link href="/register" className="font-medium text-gray-800 hover:text-black underline">
                            Créez un compte
                        </Link>
                    </p>
                </div>

                <div className="bg-white p-8 border border-gray-200 rounded-xl shadow-sm">
                    <form onSubmit={handleSubmit} className="space-y-6">
                        <div>
                            <label htmlFor="email" className="block text-sm font-medium text-gray-700">Adresse e-mail</label>
                            <input id="email" type="email" required value={email} onChange={(e) => setEmail(e.target.value)}
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 text-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500"
                            />
                        </div>
                        <div>
                            <label htmlFor="password" className="block text-sm font-medium text-gray-700">Mot de passe</label>
                            <input id="password" type="password" required value={password} onChange={(e) => setPassword(e.target.value)}
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 text-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-gray-500 focus:border-gray-500"
                            />
                        </div>
                        {error && <p className="text-sm text-red-600">{error}</p>}
                        <div>
                            <button type="submit" className="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-gray-900 hover:bg-black focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black">
                                Se connecter
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    );
}